/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import java.util.Set;

public final class CopyValueDetailFilterToQuery
extends Transformation {
    public static final String PROP_QUERY_VDF = "queryValueDetailFilter";

    public CopyValueDetailFilterToQuery() {
        this.mName = "Copy V5 detail filters and Slicer within a CogMDX query as CogMDXDetailFilter and Slicer.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        node.getParent().setPropertyValue(PROP_QUERY_VDF, (AbstractMDXBooleanExpression)nodeFactory.deepCopyNode(node.getChild(0)));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        node.throwOnInvalidChildCategories();
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getParent();
        if (mdxQuery.getPropertyValue(PROP_QUERY_VDF) != null) {
            this.traceNodeCondition(false, "The query detail filters are already copied to MDXQuery.", trace);
            return false;
        }
        if (!mdxQuery.supportFetchingDataWithQueryContext()) {
            this.traceNodeCondition(false, "No filter context support in LOLAP cube for this provdier.", trace);
            return false;
        }
        Set<IHierarchy> hierarchies = ((AbstractMDXBooleanExpression)node.getChild(0)).getReferencedHierarchies();
        for (IHierarchy hierarchy : hierarchies) {
            if (hierarchy.getDimension().isMeasuresDimension()) continue;
            this.traceNodeCondition(false, "Exclude the case when VDF has non measure hierarchy involved.", trace);
            return false;
        }
        if (mdxQuery.getNumberChildrenOfType(1095) > 1) {
            this.traceNodeCondition(false, "The query has more than one valude detail filters after normalizatin. Exclude the case.", trace);
            return false;
        }
        IXQEQueryNode[] mdxValuesInQuery = mdxQuery.getDescendantsOfType(1059, false);
        List<IXQEQueryNode> mdxValuesInFilter = node.getDescendantsOfTypeOrdered(1059, false);
        for (IXQEQueryNode mdxValue : mdxValuesInQuery) {
            if (mdxValuesInFilter.contains(mdxValue)) continue;
            this.traceNodeCondition(false, "The query has other value expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Copy the VDF to the MDX property for later use.", trace);
        return true;
    }
}

