/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class MoveVDFToEdgeForDatabaseOnlyQuery
extends SAPBWTransformation {
    public MoveVDFToEdgeForDatabaseOnlyQuery() {
        this.mName = "Move VDF from slicer to edge for SAP.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calRef = (MDXCalculatedMemberReference)node.getChild(0).getChild(0);
        MDXCalculatedMemberDefinition calDef = calRef.getDefinition();
        AbstractMDXBooleanExpression booleanCondition = (AbstractMDXBooleanExpression)calDef.getChild(0).getChild(0);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode edge = mdxQuery.getFirstChildByType(1006);
        AbstractMDXSet edgeSet = (AbstractMDXSet)edge.getChild(0);
        List<IXQEQueryNode> sets = edgeSet.getDescendantsOfCategory(1039, false);
        XQEBaseQueryNode measureSet = null;
        if (sets != null) {
            for (IXQEQueryNode set : sets) {
                MDXSet mdxSet = (MDXSet)set;
                MDXHierInfo hierInfo = mdxSet.getHierarchyInfo();
                if (hierInfo.getNumProjectedHierarchies() != 1 || !hierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) continue;
                measureSet = mdxSet;
                break;
            }
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet newSet = null;
        MDXFilter mdxFilter = MDXBuilder.buildMDXFilterExpr(nodeFactory, edgeSet, booleanCondition);
        if (measureSet != null) {
            measureSet.getParent().extract();
            newSet = (AbstractMDXSet)nodeFactory.createNode(1030);
            newSet.addChild(mdxFilter);
            measureSet.move(newSet);
        } else {
            newSet = mdxFilter;
        }
        edge.exchangeChildNode(edgeSet, newSet);
        mdxQuery.detachChild(calDef);
        mdxQuery.detachChild(node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Object applyBWDBOnly = mdxQuery.getPropertyValue("applyBWDBOnlyTransformation");
        if (applyBWDBOnly == null || applyBWDBOnly == Boolean.FALSE) {
            this.traceNodeCondition(false, "The query is not marked for BWDBOnly case.", trace);
            return false;
        }
        IXQEQueryNode[] slicers = mdxQuery.getDescendantsOfType(1008, false);
        if (slicers.length > 1) {
            this.traceNodeCondition(false, "The query has more than one slicer.", trace);
            return false;
        }
        if (node.getNumberChildren() != 1 || node.getChild(0).getNumberChildren() != 1 || node.getChild(0).getChild(0).getType() != 1013) {
            this.traceNodeCondition(false, "Only apply this transformation for VDF.", trace);
            return false;
        }
        MDXCalculatedMemberReference calRef = (MDXCalculatedMemberReference)node.getChild(0).getChild(0);
        MDXCalculatedMemberDefinition calDef = calRef.getDefinition();
        if (calDef.getNumberChildren() != 1 || calDef.getChild(0).getNumberChildren() == 0 || !calDef.getChild(0).getChild(0).isOfCategory(1071)) {
            this.traceNodeCondition(false, "Not a AbstractMDXBooleanExpression.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Need to modify the slicer expression and move filter to edge.", trace);
        return true;
    }
}

