/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXStringValueExpression;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXEmptySet;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.MemberFilterCriteria;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PushMemberFilterToBapiAPI
extends SAPBWTransformation {
    private static final String NEWLINE = "\n";
    public static final XQELogger XQELOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.ERROR);

    public PushMemberFilterToBapiAPI() {
        this.mName = "Push the evaluation of a Filter expression to BAPI.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXLevelInfo levelInfo = ((AbstractMDXNode)node.getChild(0).getChild(0)).getLevelInfo();
        MDXHierInfo hierInfo = levelInfo.getHierarchyInfo();
        List<IHierarchy> hierarchies = hierInfo.getProjectedHierarchies();
        ILevel level = levelInfo.getLowestProjectedLevel(hierarchies.get(0));
        RequestParameters parameters = environment.getMultiRequestContext().getRequestParameters();
        long ticks = System.currentTimeMillis();
        if (this.isTracing()) {
            StringBuilder message = new StringBuilder("Evaluate Named Set with Filter through BAPI. Original MDX:").append(NEWLINE);
            node.getAncestorOfType(1002).writeFormattedText(message);
            XQELOGGER.log(message.toString());
        }
        IXQEQueryNode booleanExprNode = node.getChild(0).getChild(1);
        Map<String, MemberRecord> filteredMembers = this.evaluateFilter(level, booleanExprNode, parameters, -1);
        if (this.isTracing()) {
            XQELOGGER.log("Filter Execute Time:" + (System.currentTimeMillis() - ticks));
        }
        int count = 0;
        if (filteredMembers != null) {
            count = filteredMembers.size();
        }
        IXQEQueryNode child = node.getChild(0);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (count > 0) {
            ICube cube = level.getDimension().getCube();
            AbstractMDXSet resolvedFilterSet = (AbstractMDXSet)nodeFactory.createNode(1039);
            ILevel memberLevel = null;
            for (MemberRecord record : filteredMembers.values()) {
                memberLevel = cube.getDimension(record.getDimensionUniqueName()).getHierarchy(record.getHierarchyUniqueName()).getLevel(record.getLevelUniqueName());
                BaseMember member = MDXBuilder.buildMDXBaseMemberExpr(nodeFactory, record.getUniqueName(), memberLevel);
                resolvedFilterSet.addChild(member);
            }
            node.exchangeChildNode(child, resolvedFilterSet, false);
        } else {
            CogMDXEmptySet emptyTopCount = (CogMDXEmptySet)nodeFactory.createNode(1145);
            BaseHierarchy hier = MDXBuilder.buildMDXBaseHierarchyExpr(nodeFactory, level.getHierarchy());
            emptyTopCount.addChild(hier);
            node.exchangeChildNode(child, emptyTopCount, false);
        }
        if (this.isTracing()) {
            StringBuilder message = new StringBuilder("MDXQuery with Filter set result: ").append(NEWLINE);
            node.getAncestorOfType(1002).writeFormattedText(message);
            XQELOGGER.log(message.toString());
        }
        if (booleanExprNode.getFirstDescendantOfTypeOrdered(1159, false) != null) {
            ((V5QuerySet)node.getAncestorOfType(101002)).setNonReusable(true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (!mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "The MDXQuery is NOT against LOLAP. ", trace);
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("v5.useBAPIForMemberFilterOptimization")) {
            this.traceNodeCondition(false, "The Filter optimization is disabled", trace);
            return false;
        }
        node.throwOnInvalidChildCategories();
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() != 1053) {
            this.traceNodeCondition(false, "The Filter expression is not found", trace);
            return false;
        }
        child.throwOnInvalidChildCategories();
        int[] refType = new int[]{1014, 1013, 1015, 1004};
        IXQEQueryNode[] refs = child.getDescendantsOfTypes(refType, false);
        if (refs.length > 0) {
            this.traceNodeCondition(false, "The Filter expressions contains a reference to a named set, calculated member or a set alias ", trace);
            return false;
        }
        MDXLevelInfo levelInfo = ((AbstractMDXNode)child.getChild(0)).getLevelInfo();
        MDXHierInfo hierInfo = levelInfo.getHierarchyInfo();
        List<IHierarchy> hierarchies = hierInfo.getProjectedHierarchies();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "There is more than one projected hierarchies in the dataset", trace);
            return false;
        }
        ILevel level = levelInfo.getLowestProjectedLevel(hierarchies.get(0));
        int cardinality = level.getDimension().getCardinality();
        if (cardinality < capabilities.getIntegerValue("v5.memberFilterOptimization.datasetSize")) {
            this.traceNodeCondition(false, "The cardinality of the set does not exceed the configurable threshold", trace);
            return false;
        }
        StringBuilder msg = new StringBuilder();
        boolean status = this.checkLogicExpression(child.getChild(1), environment, msg);
        this.traceNodeCondition(status, msg.toString(), trace);
        return status;
    }

    private boolean checkLogicExpression(IXQEQueryNode child, PlanningEnvironment environment, StringBuilder msg) {
        if (child.getType() == 1070) {
            if (child.getChild(0).getType() != 1016) {
                msg.append("The filter set is not against a dimension property.");
                return false;
            }
            if (child.getChild(1).getType() != 1127 && child.getChild(1).getType() != 1159) {
                msg.append("The filter doesn't compare dimension property with an expected String constant value.");
                return false;
            }
            if (child.getType() == 1070) {
                MDXComparisonOperator mdxComparisonOperator = (MDXComparisonOperator)child;
                switch (mdxComparisonOperator.getOperatorType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        msg.append("The filter comparison type is not supported by BAPI.");
                        return false;
                    }
                }
            }
        } else if (child.getType() == 1111 || child.getType() == 1110) {
            IXQEQueryNode[] grandChildren = child.getChildren();
            boolean isSupportedStringCompare = true;
            for (IXQEQueryNode grandChild : grandChildren) {
                isSupportedStringCompare = this.checkLogicExpression(grandChild, environment, msg);
                if (isSupportedStringCompare) continue;
                return false;
            }
        } else {
            return false;
        }
        msg.append("The filter expression matches the optimization pattern.");
        return true;
    }

    private Map<String, MemberRecord> evaluateFilter(ILevel level, IXQEQueryNode booleanExprNode, RequestParameters parameters, int operation) {
        int currentOpType = booleanExprNode.getType();
        if (currentOpType == 1070) {
            return this.executeBAPI(booleanExprNode, level, parameters, new ArrayList<String>(), operation);
        }
        if (currentOpType == 1111 || currentOpType == 1110) {
            ArrayList<String> currentValues = new ArrayList<String>();
            if (this.couldNormalizeToSingleBAPI(booleanExprNode, currentValues, parameters, new String[1])) {
                return this.executeBAPI(booleanExprNode, level, parameters, currentValues, currentOpType);
            }
            IXQEQueryNode[] grandChildren = booleanExprNode.getChildren();
            Map<String, MemberRecord> bapiResult1 = this.evaluateFilter(level, grandChildren[0], parameters, currentOpType);
            Map<String, MemberRecord> bapiResult2 = this.evaluateFilter(level, grandChildren[1], parameters, currentOpType);
            if (booleanExprNode.getType() == 1111) {
                if (bapiResult1 != null && bapiResult2 != null) {
                    TreeMap<Integer, MemberRecord> orderedMap = new TreeMap<Integer, MemberRecord>();
                    for (Map.Entry<String, MemberRecord> entry : bapiResult1.entrySet()) {
                        MemberRecord record = entry.getValue();
                        orderedMap.put(record.getMemberOrdinal(), record);
                    }
                    for (Map.Entry<String, MemberRecord> entry : bapiResult2.entrySet()) {
                        MemberRecord unionRecord = entry.getValue();
                        if (bapiResult1.containsKey(entry.getKey())) continue;
                        orderedMap.put(unionRecord.getMemberOrdinal(), unionRecord);
                    }
                    bapiResult1.clear();
                    for (MemberRecord record : orderedMap.values()) {
                        bapiResult1.put(record.getUniqueName(), record);
                    }
                } else if (bapiResult1 == null && bapiResult2 != null) {
                    bapiResult1 = bapiResult2;
                }
            } else if (bapiResult1 != null && bapiResult2 != null) {
                bapiResult1.keySet().retainAll(bapiResult2.keySet());
            } else {
                bapiResult1 = null;
            }
            return bapiResult1;
        }
        return null;
    }

    private boolean couldNormalizeToSingleBAPI(IXQEQueryNode booleanExprNode, List<String> values, RequestParameters parameters, String[] propertyName) {
        boolean isSingleBAPI = true;
        int rootOperationType = booleanExprNode.getType();
        String currentPropertyName = null;
        int topComparisonType = -1;
        for (IXQEQueryNode child : booleanExprNode.getChildren()) {
            if (child.getType() == 1070) {
                IXQEQueryNode propertyNode = child.getChild(0).getChild(0);
                currentPropertyName = ((BaseProperty)propertyNode).getMDXName();
                if (propertyName[0] == null) {
                    propertyName[0] = currentPropertyName;
                }
                if (!currentPropertyName.equals(propertyName[0])) {
                    return false;
                }
                AbstractMDXStringValueExpression stringNode = (AbstractMDXStringValueExpression)child.getChild(1);
                this.getStringValues(stringNode, parameters, values);
                int curretOp = ((MDXComparisonOperator)child).getOperatorType();
                if (topComparisonType == -1) {
                    topComparisonType = curretOp;
                    continue;
                }
                if (topComparisonType == curretOp) continue;
                return false;
            }
            if (rootOperationType != child.getType()) {
                isSingleBAPI = false;
                continue;
            }
            isSingleBAPI = this.couldNormalizeToSingleBAPI(child, values, parameters, propertyName);
            if (isSingleBAPI) continue;
            return false;
        }
        return isSingleBAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, MemberRecord> executeBAPI(IXQEQueryNode node, ILevel level, RequestParameters parameters, List<String> values, int operation) {
        if (node.getType() == 1070 && values.isEmpty()) {
            AbstractMDXStringValueExpression stringNode = (AbstractMDXStringValueExpression)node.getChild(1);
            this.getStringValues(stringNode, parameters, values);
        } else {
            node = node.getFirstChildByType(1070);
        }
        String propertyName = null;
        String propertyUniqueName = null;
        IXQEQueryNode propertyNode = node.getChild(0).getChild(0);
        propertyName = ((BaseProperty)propertyNode).getMDXName();
        IQueryItem propertyMetada = ((BaseProperty)propertyNode).getPropertyMetadata();
        ILevel propertyLevel = null;
        if (propertyMetada != null) {
            propertyUniqueName = propertyMetada.getUniqueName();
            propertyLevel = propertyMetada.getLevel();
        }
        MemberFilterCriteria filterCriteria = new MemberFilterCriteria(propertyName, propertyUniqueName, ((MDXComparisonOperator)node).getOperatorType(), values, operation);
        IHierarchy hierarchy = level.getHierarchy();
        IDimension dimension = hierarchy.getDimension();
        ICube cube = dimension.getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        String keyDate = MetadataUtil.getKeydateWithConfig((String)level.getHierarchy().getProperty("Valid_From"), (String)level.getHierarchy().getProperty("Valid_To"), ds.getCapabilities().isSupported("use.valid.from"));
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimension.getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierarchy.getUniqueName());
        if (propertyLevel != null) {
            restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, propertyLevel.getUniqueName());
        }
        restrictions.add(RestrictionType.MEMBERSEARCH, filterCriteria);
        if (keyDate != null) {
            restrictions.add(RestrictionType.KEY_DATE, keyDate);
        }
        List<MemberRecord> memberRecords = null;
        try {
            memberRecords = metadataProvider.getMembers(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        if (memberRecords == null || memberRecords.size() == 0) {
            return null;
        }
        LinkedHashMap<String, MemberRecord> memberRecordMap = new LinkedHashMap<String, MemberRecord>(memberRecords.size());
        for (MemberRecord record : memberRecords) {
            memberRecordMap.put(record.getUniqueName(), record);
        }
        return memberRecordMap;
    }

    private void getStringValues(AbstractMDXStringValueExpression stringNode, RequestParameters parameters, List<String> values) {
        if (stringNode.getType() == 1159) {
            ParameterValues parameterValues = parameters.getParametersValueList().get(stringNode.getName());
            values.addAll(parameterValues.getExternalValues(true));
        } else {
            values.add(((MDXStringConstant)stringNode).getConstantValue());
        }
    }

    private boolean isTracing() {
        return XQELOGGER.isOn(LogLevel.INFO);
    }
}

