/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXNull;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public class SetSAPBWNullValue
extends SAPBWTransformation {
    private static final String SAPNULL = "(NULL)";

    public SetSAPBWNullValue() {
        this.mName = "Set Null value syntax property value according to the datasource";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1089};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        String nullSyntaxProperty = ((MDXNull)node).getNullValue();
        if (nullSyntaxProperty == null || !nullSyntaxProperty.equals(SAPNULL)) {
            this.traceNodeCondition(true, "SAPBW mdx null value syntax must be set to '(NULL)'.", trace);
            return true;
        }
        this.traceNodeCondition(false, "SAPBW mdx null value syntax already set. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXNull mdxNull = (MDXNull)node;
        mdxNull.setNullValue(SAPNULL);
    }
}

