/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public class SetSAPExternalCalculatedMemberName
extends SAPBWTransformation {
    private static final String SAP_MEASURE_HIERARCHY = "[Measures]";

    public SetSAPExternalCalculatedMemberName() {
        this.mName = "Set Measure unique name according to the datasource for calculated members";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1005};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (!((MDXCalculatedMemberDefinition)node).getHierarchy().getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "The calculated member is not against measure dimension.", trace);
            return false;
        }
        String name = (String)node.getPropertyValue("externalName");
        if (name != null && name.startsWith(SAP_MEASURE_HIERARCHY)) {
            this.traceNodeCondition(false, "The measure dimension already has a valid name.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to replace the measure dimension name with its SAP technical name.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition cmd = (MDXCalculatedMemberDefinition)node;
        String un = cmd.getUniqueName();
        int index = un.indexOf(".");
        String exterUN = un.replace(un.substring(0, index), SAP_MEASURE_HIERARCHY);
        cmd.setPropertyValue("externalName", exterUN);
        cmd.setCustomUniqueName(exterUN);
    }
}

