/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public class SetSAPExternalHeirarchyName
extends SAPBWTransformation {
    private static final String SAP_MEASURE_HIERARCHY = "[Measures]";

    public SetSAPExternalHeirarchyName() {
        this.mName = "Set Measure unique name according to the datasource for calculated members";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1073};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (!((BaseHierarchy)node).getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "The base hierarchy is not from measure dimension.", trace);
            return false;
        }
        String name = (String)node.getPropertyValue("externalName");
        if (name != null && name.equals(SAP_MEASURE_HIERARCHY)) {
            this.traceNodeCondition(false, "The measure dimension already has a valid name.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to replace the measure dimension name with its SAP technical name.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue("externalName", SAP_MEASURE_HIERARCHY);
    }
}

