/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public class SetSecondParamForSAPHeadTailFunction
extends SAPBWTransformation {
    public SetSecondParamForSAPHeadTailFunction() {
        this.mName = "Set omitted second parameter for head function.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1042};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 1) {
            this.traceNodeCondition(true, "SAPBW requires the omitted second parameter.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Head/Tail function has valid number of parameters for SAP. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXNumericConstant mdxConstant = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)nodeFactory, 1);
        ((MDXHeadTailFunction)node).addChild(mdxConstant);
    }
}

