/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSubset;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public class SetThirdParamForSAPSubsetFunction
extends SAPBWTransformation {
    public SetThirdParamForSAPSubsetFunction() {
        this.mName = "Set omitted third argument for the subset function.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1090};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 2) {
            this.traceNodeCondition(true, "SAPBW requires the omitted third argument.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Subset function has valid number of parameters for SAP. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXSubset subset = (MDXSubset)node;
        MDXSet set = (MDXSet)subset.getChild(0);
        int setSize = set.getNumberChildren();
        MDXNumericConstant numericConstant = (MDXNumericConstant)subset.getChild(1);
        int startPosition = ((Number)numericConstant.getConstantValue()).intValue();
        MDXNumericConstant mdxConstant = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)nodeFactory, setSize - startPosition);
        ((MDXSubset)node).addChild(mdxConstant);
    }
}

