/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public class SetUseMetadataCallOnlyProperty
extends SAPBWTransformation {
    public SetUseMetadataCallOnlyProperty() {
        this.mName = "Set useMetadataCallOnly property if there is multiple startAt_ref in an MA query. ";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        Boolean propValue = (Boolean)mdxQuery.getPropertyValue("useMetadataCallOnly");
        if (propValue != null) {
            this.traceNodeCondition(false, "The property has set.", trace);
            return false;
        }
        MACollection memberCollection = (MACollection)node.getAncestorOfType(1101019);
        if (null != memberCollection && memberCollection.useMetadataCallOnly()) {
            this.traceNodeCondition(true, "Need to use only provider metadata calls.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Both MDX and provider metadata calls can be used to process the query. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setUseMetadataCallOnly(new Boolean(true));
        mdxQuery.setUseLocalQueryProcessing(new Boolean(true));
        mdxQuery.disableLocalSubMDXQueryRequest();
    }
}

