/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import java.util.Iterator;

public final class UseLOLAPForContextDependentSet
extends SAPBWTransformation {
    public UseLOLAPForContextDependentSet() {
        this.mName = "Use LOLAP for Context Dependent Set Expressions.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1041, 1053, 1058, 1042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        mdxQuery.setUseLocalQueryProcessing(Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing() || mdxQuery.getPropertyValue("forceLocalQueryProcessing") != null) {
            this.traceNodeCondition(false, "The property is already set.", trace);
            return false;
        }
        AbstractMDXSet targetSet = (AbstractMDXSet)node;
        MDXHierInfo setHierInfo = targetSet.getHierarchyInfo();
        MDXHierInfo contextHierInfo = targetSet.getContextHierarchyInfo();
        Iterator<IHierarchy> it = contextHierInfo.getProjectedHierarchies().iterator();
        boolean contextDependent = false;
        IHierarchy hierarchy = null;
        while (it.hasNext()) {
            hierarchy = it.next();
            if (setHierInfo.projectsHierarchy(hierarchy) || !targetSet.isContextDependent(hierarchy)) continue;
            contextDependent = true;
            break;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (hierarchy != null && contextDependent && capabilities.isSupported("v5.useLOLAPForContextDependentSet")) {
            this.traceQueryCondition(true, "Target set is context dependent on " + hierarchy + ". Use LOLAP.", trace);
            return true;
        }
        this.traceQueryCondition(false, "Target set is not context dependent on any hierarchy in context.", trace);
        return false;
    }
}

