/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public final class UseLOLAPForFunctionAncestors
extends SAPBWTransformation {
    public UseLOLAPForFunctionAncestors() {
        this.mName = "Use LOLAP for function ANCESTORS.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1044};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        mdxQuery.setUseLocalQueryProcessing(Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing() || mdxQuery.getPropertyValue("forceLocalQueryProcessing") != null) {
            this.traceNodeCondition(false, "The property is already set.", trace);
            return false;
        }
        if (node.getNumberChildren() != 2) {
            this.traceQueryCondition(false, "LOLAP does not support the number of children in ancestors function.", trace);
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("v5.useLOLAPForFunctions")) {
            this.traceQueryCondition(false, "Configuration does not use LOLAP for such pattern.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The ancestors function have 2 arguments", trace);
        return true;
    }
}

