/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.tm1;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.tm1.TM1Transformation;

public final class MoveMeasureCrossjoinLocation
extends TM1Transformation {
    public MoveMeasureCrossjoinLocation() {
        this.mName = "Move Measure Crossjoin Location";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1030};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        while (parent.getParent().getType() == 1030 && parent.getParent().getPositionOfChild(parent) == 1) {
            parent = parent.getParent();
        }
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode newCrossjoin = factory.createNode(1030);
        parent.insertParent(newCrossjoin);
        node.getChild(1).move(newCrossjoin);
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getParent().getType() != 1030 || node.getParent().getPositionOfChild(node) != 1) {
            this.traceNodeCondition(false, "The parent node is not an MDXCrossjoin node.", trace);
            return false;
        }
        node.throwOnInvalidChildCategories();
        AbstractMDXSet measureSet = (AbstractMDXSet)node.getChild(1);
        MDXHierInfo hierInfo = measureSet.getHierarchyInfo();
        if (!hierInfo.projectsMeasures() || hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The second child of the MDXCrossjoin does not project measures only.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The measures set can be moved to another location.", trace);
        return true;
    }
}

