/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.tm1;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.tm1.TM1Transformation;
import com.cognos.xqe.util.LocaleConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class SetTM1AliasTableMap
extends TM1Transformation {
    public SetTM1AliasTableMap() {
        this.mName = "Set TM1 alias table map";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        IAlias alias = (IAlias)fromCube.getAlias();
        if (alias != null) {
            mdxQuery.setAliasTable(SetTM1AliasTableMap.generateAliasTable(environment, alias));
        }
    }

    public static List<IAliasEntry> generateAliasTable(PlanningEnvironment environment, IAlias alias) {
        List<IAliasEntry> aliasentries = alias.getAliasEntries();
        Iterator<IAliasEntry> it = aliasentries.iterator();
        String runLocaleString = null;
        String runLocaleLanguage = null;
        Element connectionElement = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getConnectionElement();
        if (connectionElement != null) {
            Element runLocaleElement = null;
            runLocaleElement = connectionElement.element("runLocale");
            if (runLocaleElement != null) {
                runLocaleString = runLocaleElement.attributeValue("value");
                int i = runLocaleString.indexOf(45);
                runLocaleLanguage = i >= 0 ? runLocaleString.substring(0, i) : runLocaleString;
            }
        }
        if (runLocaleString == null) {
            runLocaleString = LocaleConverter.getLanguage(((RequestEnvironment)environment.getRequestEnvironment()).getRunLocale());
        }
        ArrayList<IAliasEntry> aliasTable = new ArrayList<IAliasEntry>();
        IAliasEntry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            if (!entry.getKey().equalsIgnoreCase(runLocaleLanguage)) continue;
            aliasTable.add(entry);
        }
        return aliasTable;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery query = (MDXQuery)node;
        if (query.getAliasTable() != null) {
            this.traceNodeCondition(false, "Alias table map is already set.", trace);
            return false;
        }
        MDXFromCube fromCube = query.getMDXFrom();
        IAlias alias = (IAlias)fromCube.getAlias();
        if (alias == null) {
            this.traceNodeCondition(false, "Cube does not have alias table.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Alias table map of TM1 query needs to be set.", trace);
        return true;
    }
}

