/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.ragged_unbalanced;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.ragged_unbalanced.AbstractRaggedUnbalancedTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;

public final class CreateCompensationSummariesForRagged
extends AbstractRaggedUnbalancedTransformation {
    public CreateCompensationSummariesForRagged() {
        this.mName = "Create Compensation Summaries For Ragged.";
        this.mPassNumbers = new int[]{16};
        this.mTypes = new int[]{1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXReportSummary cogMDXReportSummary = (CogMDXReportSummary)node;
        MDXQuery mdxQuery = (MDXQuery)cogMDXReportSummary.getAncestorOfType(1002);
        MDXEdge mdxEdge = (MDXEdge)cogMDXReportSummary.getAncestorOfType(1006);
        IHierarchy summaryHierarchy = cogMDXReportSummary.getFirstSetHierarchy();
        if (!this.isRaggedCompensationDone(null, cogMDXReportSummary, mdxQuery, summaryHierarchy, mdxEdge, true, true)) {
            mdxQuery.addCogMDXGroupNotRequiringRaggedCompensation(cogMDXReportSummary);
            cogMDXReportSummary.setRaggedNLevelProperty("compensationNAForRaggedNested");
            return;
        }
        boolean includeSelf = false;
        List<IXQEQueryNode> cogMDXGroups = mdxEdge.getDescendantsOfTypeOrdered(1027, includeSelf);
        AbstractMDXSet refCogMDXGroup = (AbstractMDXSet)cogMDXReportSummary.getDetailExpr();
        if (refCogMDXGroup.getType() == 1039 || refCogMDXGroup.getType() == 1117) {
            refCogMDXGroup = (AbstractMDXSet)refCogMDXGroup.getChild(0);
        }
        String refCogMDXGroupId = refCogMDXGroup.getId().toString();
        ArrayList<CogMDXGroup> compensationNodes = new ArrayList<CogMDXGroup>();
        for (IXQEQueryNode cogMDXGroup : cogMDXGroups) {
            CogMDXGroup currGroup = (CogMDXGroup)cogMDXGroup;
            if (currGroup.getRaggedNLevelProperty().equals(refCogMDXGroupId)) {
                compensationNodes.add(currGroup);
                continue;
            }
            if (!currGroup.getRaggedNLevelProperty().equals("processedRaggedNested") || currGroup.getUnbalancedRaggedOriginalGroup() != refCogMDXGroup) continue;
            compensationNodes.add(currGroup);
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (CogMDXGroup compensNode : compensationNodes) {
            IXQEQueryNode[] tnodeUnbcomps;
            boolean foundASingleCalcRef;
            IXQEQueryNode compensNodeParent = compensNode.getParent();
            if (compensNodeParent.getType() != 1039) {
                AbstractMDXSet tmpSet = (AbstractMDXSet)nodeFactory.createNode(1039);
                compensNodeParent.addChild(tmpSet);
                compensNode.move(tmpSet);
                compensNodeParent = tmpSet;
            }
            CogMDXReportSummary compensSummary = (CogMDXReportSummary)nodeFactory.deepCopyNode(cogMDXReportSummary);
            compensNodeParent.addChildAfterNode(compensSummary, compensNode);
            compensSummary.bindSummaryToDetailExpr(compensNode);
            compensSummary.setRaggedNLevelProperty(cogMDXReportSummary.getId().toString());
            compensSummary.setUnbalancedRaggedOriginalGroup(cogMDXReportSummary);
            IXQEQueryNode[] cpyCalcRefs = compensSummary.getDescendantsOfType(1013, includeSelf);
            IXQEQueryNode[] cogMDXAggregates = null;
            AbstractMDXSet newCompsAggrSet = (AbstractMDXSet)nodeFactory.deepCopyNode(CreateCompensationSummariesForRagged.getProjSet(compensNode));
            boolean bl = foundASingleCalcRef = cpyCalcRefs.length == 1;
            if (foundASingleCalcRef) {
                MDXCalculatedMemberReference cpyCalcRef = (MDXCalculatedMemberReference)cpyCalcRefs[0];
                AbstractMDXNode calcDef = (AbstractMDXNode)nodeFactory.deepCopyNode(cpyCalcRef.getDefinition().getChild(0));
                cogMDXAggregates = calcDef.getDescendantsOfTypes(new int[]{1060, 1012, 1087}, true);
                if (cogMDXAggregates.length != 0) {
                    AbstractMDXNumericValueFunction cogMDXAggregate = (AbstractMDXNumericValueFunction)cogMDXAggregates[0];
                    cogMDXAggregate.exchangeChildNode(cogMDXAggregate.getChild(0), newCompsAggrSet);
                    MDXCalculatedMemberReference newCalcRef = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, cpyCalcRef.getHierarchy(), "_RS", calcDef, cpyCalcRef.getDefinition().getSolveOrder());
                    cpyCalcRef.getParent().exchangeChildNode(cpyCalcRef, newCalcRef);
                } else {
                    foundASingleCalcRef = false;
                }
            }
            if (!foundASingleCalcRef) {
                cogMDXAggregates = compensSummary.getDescendantsOfTypes(new int[]{1060, 1012}, includeSelf);
                IXQEQueryNode cogMDXAggregate = cogMDXAggregates[0];
                cogMDXAggregate.exchangeChildNode(cogMDXAggregate.getChild(0), newCompsAggrSet);
            }
            includeSelf = true;
            for (IXQEQueryNode tnodeUnbcomp : tnodeUnbcomps = newCompsAggrSet.getDescendantsOfType(1113, includeSelf)) {
                IXQEQueryNode tnodeUnbcompParent = tnodeUnbcomp.getParent();
                if (tnodeUnbcompParent.getType() != 1039) {
                    AbstractMDXSet tmpSet = (AbstractMDXSet)nodeFactory.createNode(1039);
                    tnodeUnbcomp.insertParent(tmpSet);
                }
                tnodeUnbcomp.extract();
            }
            mdxEdge.setPropertyValue("raggedCompensationApplied", true);
        }
        cogMDXReportSummary.setRaggedNLevelProperty("processedRaggedNested");
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!this.applyRaggedCompensation(mdxQuery)) {
            this.traceQueryCondition(false, "The value of capability property 'applyRaggedCompensation' is false.", trace);
            return false;
        }
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        MDXEdge mdxEdge = (MDXEdge)node.getAncestorOfType(1006);
        if (mdxEdge == null || mdxQuery == null) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append("within both a MDXQuery and a MDXEdge node.");
            status = false;
        } else {
            msgStr.append(" ");
            msgStr.append("within both a MDXQuery and a MDXEdge node.");
            status = true;
        }
        this.traceQueryCondition(status, msgStr.toString(), trace);
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXReportSummary cogMDXReportSummary = (CogMDXReportSummary)node;
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean result = this.nodeConditionForRaggedSummary(cogMDXReportSummary, traceMsg);
        this.traceNodeCondition(result, traceMsg.toString(), trace);
        return result;
    }

    protected boolean nodeConditionForRaggedSummary(CogMDXReportSummary cogMDXReportSummary, StringBuilder traceMsg) {
        boolean pass;
        IXQEQueryNode[] nestedSummaries;
        MDXQuery mdxQuery = (MDXQuery)cogMDXReportSummary.getAncestorOfType(1002);
        if (mdxQuery.getCogMDXGroupsNotRequiringRaggedCompensation().contains(cogMDXReportSummary) && traceMsg != null) {
            traceMsg.append("Ragged compensation is not required.");
            return false;
        }
        if (!cogMDXReportSummary.getRaggedNLevelProperty().equals("unprocessedRaggedNested")) {
            if (traceMsg != null) {
                traceMsg.append("The summary is not an unprocessed ragged nested summary.");
            }
            return false;
        }
        AbstractMDXSet refCogMDXGroup = (AbstractMDXSet)cogMDXReportSummary.getDetailExpr();
        if (refCogMDXGroup == null) {
            if (traceMsg != null) {
                traceMsg.append("The summary has not a detail node.");
            }
            return false;
        }
        IHierarchy summaryHierarchy = cogMDXReportSummary.getFirstSetHierarchy();
        for (IXQEQueryNode nestedSummary : nestedSummaries = refCogMDXGroup.getDescendantsOfType(1080, false)) {
            CogMDXReportSummary nestedReportSummary = (CogMDXReportSummary)nestedSummary;
            IHierarchy nestedSummaryHierarchy = nestedReportSummary.getFirstSetHierarchy();
            if (!nestedSummaryHierarchy.equals(summaryHierarchy) || !nestedReportSummary.getRaggedNLevelProperty().equals("unprocessedRaggedNested")) continue;
            if (traceMsg != null) {
                traceMsg.append("A summary nested under the detail set  has not been processed yet for ragged.");
            }
            return false;
        }
        MDXEdge mdxEdge = (MDXEdge)cogMDXReportSummary.getAncestorOfType(1006);
        if (!this.isRaggedCompensationDone(traceMsg, cogMDXReportSummary, mdxQuery, summaryHierarchy, mdxEdge, true, true)) {
            return false;
        }
        if (!this.conditionsForRefCogMDXGroup(traceMsg, refCogMDXGroup)) {
            return false;
        }
        CogMDXReportSummary orgSummary = (CogMDXReportSummary)cogMDXReportSummary.getUnbalancedRaggedOriginalGroup();
        if (orgSummary != null && orgSummary.getRaggedNLevelProperty().equals("unprocessedRaggedNested")) {
            if (traceMsg != null) {
                traceMsg.append("Wait until the original node has been proceed");
            }
            return false;
        }
        boolean includeSelf = false;
        IXQEQueryNode[] calcRefs = cogMDXReportSummary.getDescendantsOfType(1013, includeSelf);
        IXQEQueryNode[] aggrs = cogMDXReportSummary.getDescendantsOfTypes(new int[]{1060, 1012}, includeSelf);
        boolean bl = pass = calcRefs.length == 1;
        if (!pass) {
            boolean bl2 = pass = aggrs.length == 1 && aggrs[0].getParent().isOfCategory(1028);
        }
        if (!pass) {
            if (traceMsg != null) {
                traceMsg.append("The summary is not containing either a single MDXCalculatedMemberReference node");
                traceMsg.append(" or a single CogMDXAggregate node.");
            }
            return false;
        }
        if (traceMsg != null) {
            traceMsg.append("The summary is ready for the transformation.");
        }
        return true;
    }

    private boolean conditionsForRefCogMDXGroup(StringBuilder traceMsg, AbstractMDXSet refCogMDXGroup) {
        String s1 = "The detail node for this summary has not been processed for ragged yet.";
        if (refCogMDXGroup.getType() == 1026) {
            if (!refCogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
                refCogMDXGroup.throwInternalError("COGMDX_NEST && !isMeasuresDimension()");
            }
            if (traceMsg != null) {
                traceMsg.append("Transformation is not required for measure summaries.");
            }
            return false;
        }
        if (this.getRaggedNLevelProperty(refCogMDXGroup) == "unprocessedRaggedNested") {
            if (traceMsg != null) {
                traceMsg.append("The detail node for this summary has not been processed for ragged yet.");
            }
            return false;
        }
        if (refCogMDXGroup.getType() != 1027 && refCogMDXGroup.getType() != 1039 && refCogMDXGroup.getType() != 1117) {
            refCogMDXGroup.throwInternalError("!COGMDX_GROUP && !MDX_SET && !TNODE_SORT");
        }
        if (refCogMDXGroup.getType() == 1039 || refCogMDXGroup.getType() == 1117) {
            refCogMDXGroup = (AbstractMDXSet)refCogMDXGroup.getChild(0);
        }
        if (this.getRaggedNLevelProperty(refCogMDXGroup).equals("unprocessedRaggedNested")) {
            if (traceMsg != null) {
                traceMsg.append("The detail node for this summary has not been processed for ragged yet.");
            }
            return false;
        }
        return true;
    }
}

