/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleUnrefHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.List;

public final class AddAggrForMDFOnUnrefHierToSlicer
extends Transformation {
    public AddAggrForMDFOnUnrefHierToSlicer() {
        this.mName = "Add Aggregation For Member Detail Filter On Unreferenced Hierarchy To Slicer.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1094};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXHierInfo dfInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo();
        IHierarchy dfHierarchy = dfInfo.getProjectedHierarchy(0);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedMDFsOnHierarchy(mdxQuery, dfHierarchy);
        AbstractMDXSet dfSet = (AbstractMDXSet)DFSLAggrUtil.getSingleMDFAggregationSet((TNodeMDFOnSingleUnrefHierarchy)node).detach();
        MDXSummaryFunction aggrExpr = (MDXSummaryFunction)factory.createNode(1060);
        aggrExpr.setSummaryType(MDXSummaryFunctionTypeEnum.AGGREGATE);
        aggrExpr.addChild(dfSet);
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, dfHierarchy, "_MDF", aggrExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        MDXTuple dimLineTuple = DFSLAggrUtil.getCreateDimLineTuple(factory, mdxQuery);
        if (dimLineTuple.getNumberChildren() == 1) {
            dimLineTuple.throwOnInvalidChildCategories();
            IXQEQueryNode dimLineMember = dimLineTuple.detachChild(0);
            dimLineMember = MDXBuilder.coerceToNumericValueExpression((AbstractMDXMember)dimLineMember, factory);
            aggrExpr.addChild(dimLineMember);
        }
        dimLineTuple.addChild(cm);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!DFSLAggrUtil.isMDFReadyToBeApplied((TNodeMDFOnSingleUnrefHierarchy)node)) {
            this.traceNodeCondition(false, "The member detail filter does not have required information. BuildAggrForMDFOnUnrefHier and SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        if (DFSLAggrUtil.getReaggregationHostName((TNodeMDFOnSingleUnrefHierarchy)node).compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The member detail filter is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (mdxQuery.getDescendantsOfTypes(new int[]{1097, 1185, 1098, 1193}, false).length > 0) {
            this.traceNodeCondition(false, "There are TNodeSlicer nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        MDXTuple dimLineTuple = null;
        if (dimLine != null) {
            if (dimLine.getNumberChildren() != 1 || !dimLine.getChild(0).isOfCategory(1068)) {
                this.traceNodeCondition(false, "The DimensionLine node does not contain a single MDXTuple child node.", trace);
                return false;
            }
            dimLineTuple = (MDXTuple)dimLine.getChild(0);
        }
        if (dimLineTuple != null) {
            MDXHierInfo dimLineTupleHierInfo = dimLineTuple.getHierarchyInfo();
            CogMDXIn cogMDXIn = (CogMDXIn)node.getChild(0);
            MDXHierInfo dfSetHierInfo = ((AbstractMDXSet)cogMDXIn.getChild(1)).getHierarchyInfo();
            if (dfSetHierInfo.projectedHierarchiesOverlap(dimLineTupleHierInfo)) {
                this.traceNodeCondition(false, "The first child of the target TNodeMDFOnSingleUnrefHierarchy node is a condition on a hierarchy that is already projected on the dimension line.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "The first child of the target TNodeMDFOnSingleUnrefHierarchy node is a condition on a hierarchy that is not already projected on the dimension line.", trace);
        return true;
    }
}

