/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.List;

public final class AddAggrForMDFToSlicerUsingSlicerHier
extends Transformation {
    public AddAggrForMDFToSlicerUsingSlicerHier() {
        this.mName = "Add Aggregation For Member Detail Filter To Slicer Using Slicer Hierarchy.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXNumericIIF iifExpr = DFSLAggrUtil.buildMDFReaggregationExpression(factory, mdxQuery, (TNodeMDFOnSingleHierarchy)node, true);
        MDXHierInfo dfHierInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo();
        IHierarchy dfHierarchy = dfHierInfo.getProjectedHierarchy(0);
        MDXTuple dimLineTuple = DFSLAggrUtil.getCreateDimLineTuple(factory, mdxQuery);
        AbstractMDXMember dimLineMember = (AbstractMDXMember)dimLineTuple.detachChild(0);
        DFSLAggrUtil.addMemberToContextDependentCompleteTuples(factory, mdxQuery, node, dimLineMember);
        iifExpr.addMemberToContext(factory, dimLineMember, true);
        IHierarchy dimLineMemberHierarchy = dimLineMember.getHierarchyInfo().getProjectedHierarchy(0);
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, dimLineMemberHierarchy, "_MDF", iifExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        dimLineTuple.addChild(cm, 0);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedMDFsOnHierarchy(mdxQuery, dfHierarchy);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!DFSLAggrUtil.isMDFReadyToBeApplied((TNodeMDFOnSingleHierarchy)node)) {
            this.traceNodeCondition(false, "The member detail filter does not have required information. BuildAggrForMDF and SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        if (DFSLAggrUtil.getReaggregationHostName((TNodeMDFOnSingleHierarchy)node).compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The member detail filter is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        MDXTuple dimLineTuple = null;
        if (dimLine == null || dimLine.getNumberChildren() != 1 || !dimLine.getChild(0).isOfCategory(1068) || dimLine.getChild(0).getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Either the MDXQuery does not have a DimensionLine node, the DimensionLine node does not have a single MDXTuple child node, or the MDXTuple node does not have any child nodes.", trace);
            return false;
        }
        dimLineTuple = (MDXTuple)dimLine.getChild(0);
        MDXHierInfo mdfHierInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo();
        IHierarchy mdfHierarchy = mdfHierInfo.getProjectedHierarchy(0);
        MDXHierInfo dimLineHierInfo = dimLineTuple.getHierarchyInfo();
        if (dimLineHierInfo.projectsHierarchy(mdfHierarchy)) {
            this.traceNodeCondition(false, "The target TNodeMDFOnSingleHierarchy node is filtering a hierarchy that is already projected on the dimension line.", trace);
            return false;
        }
        List<AbstractMDXNode> slicerSets = dimLineTuple.getDescendantsOfCategory(1021, true, true, true, true, false);
        for (AbstractMDXSet abstractMDXSet : slicerSets) {
            if (abstractMDXSet.getPropertyValue("DFSLAggrSet") != Boolean.TRUE || !abstractMDXSet.getHierarchyInfo().projectsHierarchy(mdfHierarchy)) continue;
            this.traceNodeCondition(false, "The DimensionLine contains an aggregation calculation for members in the same hierarchy as the detail filter.  The ApplyAggrForMDFToSlicerUsingSlicerReAggr transformation should be applied instead.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The DimensionLine projects a hierarchy that can be used to aggregate the values for members that belong to the hierarchy that is filtered by the target TNodeMDFOnSingleHierarchy node.", trace);
        return true;
    }
}

