/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import java.util.ArrayList;
import java.util.List;

public final class AddAggrForMDFToSlicerUsingSlicerReAggr
extends Transformation {
    public AddAggrForMDFToSlicerUsingSlicerReAggr() {
        this.mName = "Add Aggregation For Member Detail Filter To Slicer Using Slicer Reaggregation.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXSet aggregationSet = (AbstractMDXSet)DFSLAggrUtil.getSingleMDFAggregationSet((TNodeMDFOnSingleHierarchy)node).detach();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXHierInfo dfInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo();
        IHierarchy dfHierarchy = dfInfo.getProjectedHierarchy(0);
        List<AbstractMDXNode> slicerReaggrSets = mdxQuery.getDimensionLine().getDescendantsOfCategory(1021, true, true, true, true, false);
        ArrayList<AbstractMDXSet> targetSlicerSets = new ArrayList<AbstractMDXSet>();
        for (AbstractMDXSet abstractMDXSet : slicerReaggrSets) {
            if (abstractMDXSet.getPropertyValue("DFSLAggrSet") != Boolean.TRUE || !abstractMDXSet.getHierarchyInfo().projectedHierarchiesOverlap(dfInfo)) continue;
            targetSlicerSets.add(abstractMDXSet);
        }
        Object var11_12 = null;
        for (AbstractMDXSet targetSlicerSet : targetSlicerSets) {
            void var11_16;
            void var11_13;
            MDXIntersect mdxIntersect = (MDXIntersect)factory.createNode(1038);
            mdxIntersect.setAll(true);
            targetSlicerSet.insertParent(mdxIntersect);
            if (var11_13 == null) {
                AbstractMDXSet abstractMDXSet = aggregationSet;
            } else {
                IXQEQueryNode iXQEQueryNode = factory.deepCopyNode(aggregationSet);
            }
            mdxIntersect.addChild((IXQEQueryNode)var11_16, 0);
        }
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedMDFsOnHierarchy(mdxQuery, dfHierarchy);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!DFSLAggrUtil.isMDFReadyToBeApplied((TNodeMDFOnSingleHierarchy)node)) {
            this.traceNodeCondition(false, "The member detail filter does not have required information. BuildAggrForMDF and SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        if (DFSLAggrUtil.getReaggregationHostName((TNodeMDFOnSingleHierarchy)node).compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The member detail filter is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        List<AbstractMDXNode> slicerSets = null;
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine != null) {
            slicerSets = dimLine.getDescendantsOfCategory(1021, true, true, true, true, false);
        }
        if (slicerSets != null) {
            MDXHierInfo mdfHierInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo();
            for (AbstractMDXSet abstractMDXSet : slicerSets) {
                MDXHierInfo slicerSetHierInfo;
                if (abstractMDXSet.getPropertyValue("DFSLAggrSet") != Boolean.TRUE || !(slicerSetHierInfo = abstractMDXSet.getHierarchyInfo()).projectedHierarchiesOverlap(mdfHierInfo)) continue;
                this.traceNodeCondition(true, "The DimensionLine contains an aggregation calculation for members in the same hierarchy as the detail filter.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "Either DimensionLine is empty, or it does not contain an aggregation calculation for members in the same hierarchy as the detail filter.", trace);
        return false;
    }
}

