/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.List;

public final class AddAggrForMDFToSlicerUsingUnrefHier
extends Transformation {
    public AddAggrForMDFToSlicerUsingUnrefHier() {
        this.mName = "Add Aggregation For Member Detail Filter To Slicer Using Unreferenced Hierarchy.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXNumericIIF numericIIF = DFSLAggrUtil.buildMDFReaggregationExpression(factory, mdxQuery, (TNodeMDFOnSingleHierarchy)node, true);
        IHierarchy unreferencedHierarchy = mdxQuery.getUnreferencedHierarchy();
        MDXDefaultMember mdxDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, unreferencedHierarchy);
        DFSLAggrUtil.addMemberToContextIndependentSets(factory, mdxQuery, node, mdxDefaultMember);
        numericIIF.addMemberToContext(factory, mdxDefaultMember, true);
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, unreferencedHierarchy, "_MDF", numericIIF, SolveOrderUtil.getCubeCalcSolveOrder());
        MDXTuple dimLineTuple = DFSLAggrUtil.getCreateDimLineTuple(factory, mdxQuery);
        dimLineTuple.addChild(cm);
        MDXHierInfo dfHierInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo();
        IHierarchy dfHierarchy = dfHierInfo.getProjectedHierarchy(0);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedMDFsOnHierarchy(mdxQuery, dfHierarchy);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXDimensionLine dimLine;
        XQETrace trace = environment.getTrace();
        if (!DFSLAggrUtil.isMDFReadyToBeApplied((TNodeMDFOnSingleHierarchy)node)) {
            this.traceNodeCondition(false, "The member detail filter does not have required information. BuildAggrForMDF and SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        if (DFSLAggrUtil.getReaggregationHostName((TNodeMDFOnSingleHierarchy)node).compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The member detail filter is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (!((dimLine = mdxQuery.getDimensionLine()) == null || dimLine.getNumberChildren() <= 0 || dimLine.getNumberChildren() == 1 && dimLine.getChild(0).isOfCategory(1068) && dimLine.getChild(0).getNumberChildren() == 0)) {
            this.traceNodeCondition(false, "The query has a  DimensionLine node that has a single MDXTuple child node with at least one child node.  Either the ApplyAggrForMDFToSlicerUsingSlicerHier transformation or the ApplyAggrForMDFToSlicerUsingSlicerReAggr transformation should be applied instead.", trace);
            return false;
        }
        if (mdxQuery.getUnreferencedHierarchy() == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TransformationFailNoUnrefHier, this.mName, XQEIntegerPool.getInteger(node.getId()).toString());
        }
        this.traceNodeCondition(true, "There is an unreferenced hierarchy available that can be used to create a calculated member on the DimensionLine.", trace);
        return true;
    }
}

