/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class AddAggrForORdMDFsOnDiffHiersToSlicerUsingUnrefHier
extends Transformation {
    public AddAggrForORdMDFsOnDiffHiersToSlicerUsingUnrefHier() {
        this.mName = "Add Aggregation For ORd Member Detail Filters On Different Hierarchies To Slicer Using Unreferenced Hierarchy";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1107};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy unreferencedHierarchy = mdxQuery.getUnreferencedHierarchy();
        MDXDefaultMember mdxDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, unreferencedHierarchy);
        DFSLAggrUtil.addMemberToContextIndependentSets(factory, mdxQuery, node, mdxDefaultMember);
        MDXOr dfORCondition = (MDXOr)node.getChild(0);
        MDXSummaryFunction aggrExpr = DFSLAggrUtil.constructMDFAggregationCalc(factory, mdxQuery, dfORCondition);
        aggrExpr.addMemberToContext(factory, mdxDefaultMember, false);
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, unreferencedHierarchy, "_MDF", aggrExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        MDXTuple dimLineTuple = DFSLAggrUtil.getCreateDimLineTuple(factory, mdxQuery);
        dimLineTuple.addChild(cm);
        node.setPropertyValue("AggregationApplied", Boolean.TRUE);
        mdxDefaultMember.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") == null) {
            this.traceNodeCondition(false, "The target TNodeORdMDFsOnDiffHiers node has not yet been flagged as necessitating aggregation in the query.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationRequired") == Boolean.FALSE) {
            this.traceNodeCondition(false, "The query does not require aggregation for the target TNodeORdMDFsOnDiffHiers node.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Aggregation has already been applied for the target TNodeORdMDFsOnDiffHiers node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeORdMDFsOnDiffHiers node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (mdxQuery.getDescendantsOfTypes(new int[]{1097, 1185, 1098}, false).length > 0) {
            this.traceNodeCondition(false, "There are TNodeSlicer nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        int[] nodeTypes = new int[]{1093, 1094};
        IXQEQueryNode[] mdfNodes = mdxQuery.getDescendantsOfTypes(nodeTypes, false);
        for (int i = 0; i < mdfNodes.length; ++i) {
            if (mdfNodes[i].getPropertyValue("AggregationRequired") == Boolean.FALSE || node.getPropertyValue("AggregationRequired") == Boolean.TRUE && node.getPropertyValue("AggregationApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "There is a TNodeMDFOnSingle(Unref)Hierarchy node in this query for which aggregation has not yet been applied.", trace);
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (!(dimLine == null || dimLine.getNumberChildren() <= 0 || dimLine.getNumberChildren() == 1 && dimLine.getChild(0).isOfCategory(1068) && dimLine.getChild(0).getNumberChildren() == 0)) {
            MDXHierInfo dimLineHierInfo = ((MDXTuple)dimLine.getChild(0)).getHierarchyInfo();
            MDXOr dfORCondition = (MDXOr)node.getChild(0);
            AbstractMDXBooleanExpression[] orConditionOperands = dfORCondition.getAssociativeOperands(false);
            ArrayList<IHierarchy> filteredHierarchies = new ArrayList<IHierarchy>();
            for (int i = 0; i < orConditionOperands.length; ++i) {
                if (orConditionOperands[i].getType() != 1029 || !orConditionOperands[i].validateChildCategories()) {
                    throw new XQERuntimeException();
                }
                AbstractMDXSet filterSet = (AbstractMDXSet)orConditionOperands[i].getChild(1);
                MDXHierInfo hierInfo = filterSet.getHierarchyInfo();
                filteredHierarchies.add(hierInfo.getProjectedHierarchy(0));
            }
            boolean dimLineProjectsFilteredHierarchy = false;
            Iterator it = filteredHierarchies.iterator();
            while (it.hasNext()) {
                if (!dimLineHierInfo.projectsHierarchy((IHierarchy)it.next())) continue;
                dimLineProjectsFilteredHierarchy = true;
                break;
            }
            if (!dimLineProjectsFilteredHierarchy) {
                MDXSummaryFunction slicerSummary;
                AbstractMDXSet slicerSummarySet;
                MDXHierInfo slicerSummaryHierInfo;
                MDXTuple dimLineTuple = (MDXTuple)dimLine.getChild(0);
                dimLineTuple.throwOnInvalidChildCategories();
                AbstractMDXMember dimLineMember = (AbstractMDXMember)dimLineTuple.getChild(0);
                List<AbstractMDXNode> slicerSummaries = dimLineMember.getDescendantsOfType(1060, true, true, true, false, false);
                if (slicerSummaries.size() != 1) {
                    dimLineMember.throwInternalError("The DimensionLine contains more than one summary.");
                }
                if ((slicerSummaryHierInfo = (slicerSummarySet = (AbstractMDXSet)(slicerSummary = (MDXSummaryFunction)slicerSummaries.iterator().next()).getChild(0)).getHierarchyInfo()).getNumProjectedHierarchies() == 1) {
                    this.traceNodeCondition(false, "The DimensionLine projects a single hierarchy that can be used to aggregate the values for members that belong to the hierarchies that are filtered by the target TNodeORdMDFsOnDiffHiers node. ApplyAggrForORdMDFsOnDiffHiersToSlicerUsingSlicerHier should be applied instead.", trace);
                    return false;
                }
            }
        }
        if (mdxQuery.getUnreferencedHierarchy() == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TransformationFailNoUnrefHier, this.mName, XQEIntegerPool.getInteger(node.getId()).toString());
        }
        this.traceNodeCondition(true, "There is an unreferenced hierarchy available that can be used to create a calculated member on the DimensionLine.", trace);
        return true;
    }
}

