/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.List;

public final class AddAggrForVDFToSlicerUsingSlicerHier
extends Transformation {
    public AddAggrForVDFToSlicerUsingSlicerHier() {
        this.mName = "Add Aggregation For Value Detail Filter To Slicer Using Slicer Hierarchy.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXTuple dimLineTuple = DFSLAggrUtil.getCreateDimLineTuple(factory, mdxQuery);
        AbstractMDXMember dLMember = (AbstractMDXMember)dimLineTuple.detachChild(0);
        IHierarchy dLMemberHierarchy = dLMember.getHierarchyInfo().getProjectedHierarchy(0);
        AbstractMDXSet aggrSet = (AbstractMDXSet)((TNodeValueDetailFilter)node).getAggregationExpression().detach();
        AbstractMDXBooleanExpression vdCond = (AbstractMDXBooleanExpression)((TNodeValueDetailFilter)node).getSingleVDFCondition().detach();
        vdCond.addMemberToContext(factory, dLMember, true);
        MDXNumericIIF iifExpr = null;
        if (aggrSet.getType() == 1039 && aggrSet.getNumberChildren() == 1 && aggrSet.getChild(0).getType() == 1076) {
            iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, vdCond, (AbstractMDXNumericValueExpression)MDXBuilder.coerceToValueExpression(dLMember, factory));
        } else {
            iifExpr = DFSLAggrUtil.buildVDFReaggregationExpression(factory, mdxQuery, aggrSet, vdCond, null, true);
            iifExpr.addMemberToContext(factory, dLMember, true);
        }
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, dLMemberHierarchy, "_VDF", iifExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        dimLineTuple.addChild(cm, 0);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedVDFs(mdxQuery);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((TNodeValueDetailFilter)node).isReadyToBeApplied()) {
            this.traceNodeCondition(false, "The value detail filter does not have required information. BuildAggrForVDF and SetVDFDestinationProperty need to be applied first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeValueDetailFilter node are invalid.", trace);
            return false;
        }
        if (((TNodeValueDetailFilter)node).getReaggregationHostName().compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The value detail filter is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (!this.isReaggregationForOtherDetailFiltersAndSlicersDone(mdxQuery, trace)) {
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine == null || dimLine.getNumberChildren() != 1 || !dimLine.getChild(0).isOfCategory(1068) || dimLine.getChild(0).getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Either the MDXQuery does not have a DimensionLine node, the DimensionLine node does not have a single MDXTuple child node, or the MDXTuple node does not have any child nodes.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The DimensionLine projects a hierarchy that can be used to re-aggregate the values for members in the based on the target TNodeValueDetailFilter node condition.", trace);
        return true;
    }

    public boolean isReaggregationForOtherDetailFiltersAndSlicersDone(MDXQuery mdxQuery, XQETrace trace) {
        if (mdxQuery.getDescendantsOfTypes(new int[]{1097, 1098, 1185}, false).length > 0) {
            this.traceNodeCondition(false, "There are TNodeSlicer nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        int[] types = new int[]{1093, 1193, 1094};
        IXQEQueryNode[] mDFTNodes = mdxQuery.getDescendantsOfTypes(types, false);
        for (int i = 0; i < mDFTNodes.length; ++i) {
            if (mDFTNodes[i].getPropertyValue("AggregationRequired") == Boolean.FALSE || mDFTNodes[i].getPropertyValue("AggregationRequired") == Boolean.TRUE && mDFTNodes[i].getPropertyValue("AggregationApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "There are TNodeMDFOnSingleHierarchy or TNodeMDFOnSingleUnrefHierarchy nodes in the query for which -aggregation has not yet been applied.", trace);
            return false;
        }
        return true;
    }
}

