/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Iterator;
import java.util.List;

public final class AddAggrForVDFToSlicerUsingUnrefHier
extends Transformation {
    public AddAggrForVDFToSlicerUsingUnrefHier() {
        this.mName = "Add Aggregation For Value Detail Filter To Slicer Using Unreferenced Hierarchy.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy unreferencedHierarchy = mdxQuery.getUnreferencedHierarchy();
        MDXDefaultMember mdxDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, unreferencedHierarchy);
        DFSLAggrUtil.addMemberToContextIndependentSets(factory, mdxQuery, node, mdxDefaultMember);
        AbstractMDXSet aggrSet = (AbstractMDXSet)((TNodeValueDetailFilter)node).getAggregationExpression().detach();
        AbstractMDXBooleanExpression vdCond = (AbstractMDXBooleanExpression)((TNodeValueDetailFilter)node).getSingleVDFCondition().detach();
        List<Integer> tnIds = ((TNodeValueDetailFilter)node).getTNodeApplyVDFSetIds();
        Iterator<Integer> it = tnIds.iterator();
        boolean includeSelf = false;
        while (it.hasNext()) {
            Integer tnId = it.next();
            IXQEQueryNode tNodeApplyVDFToSet = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(tnId);
            List<IXQEQueryNode> conditions = tNodeApplyVDFToSet.getDescendantsOfCategory(1071, includeSelf);
            for (AbstractMDXBooleanExpression abstractMDXBooleanExpression : conditions) {
                if (!abstractMDXBooleanExpression.isSameExpression(vdCond, false)) continue;
                abstractMDXBooleanExpression.addMemberToContext(factory, mdxDefaultMember, true);
            }
        }
        vdCond.addMemberToContext(factory, mdxDefaultMember, true);
        MDXNumericIIF iifExpr = null;
        if (aggrSet.getType() == 1039 && aggrSet.getNumberChildren() == 1 && aggrSet.getChild(0).getType() == 1076) {
            iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, vdCond, (AbstractMDXNumericValueExpression)MDXBuilder.coerceToValueExpression(mdxDefaultMember, factory));
        } else {
            iifExpr = DFSLAggrUtil.buildVDFReaggregationExpression(factory, mdxQuery, aggrSet, vdCond, null, true);
            iifExpr.addMemberToContext(factory, mdxDefaultMember, true);
        }
        MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, unreferencedHierarchy, "_VDF", iifExpr, SolveOrderUtil.getCubeCalcSolveOrder());
        MDXTuple dimLineTuple = DFSLAggrUtil.getCreateDimLineTuple(factory, mdxQuery);
        dimLineTuple.addChild(cm);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedVDFs(mdxQuery);
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((TNodeValueDetailFilter)node).isReadyToBeApplied()) {
            this.traceNodeCondition(false, "The value detail filter does not have required information. BuildAggrForVDF and SetReaggregationHostProperty need to be applied first.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeValueDetailFilter node are invalid.", trace);
            return false;
        }
        if (((TNodeValueDetailFilter)node).getReaggregationHostName().compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The value detail filter is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (!this.isReaggregationForOtherDetailFiltersAndSlicersDone(mdxQuery, trace)) {
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (!(dimLine == null || dimLine.getNumberChildren() <= 0 || dimLine.getNumberChildren() == 1 && dimLine.getChild(0).isOfCategory(1068) && dimLine.getChild(0).getNumberChildren() == 0)) {
            this.traceNodeCondition(false, "The query has a  DimensionLine node that has a single MDXTuple child node with at least one child node.  ApplyAggrForVDFToSlicerUsingSlicerHier should be appplied instead..", trace);
            return false;
        }
        if (mdxQuery.getUnreferencedHierarchy() == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TransformationFailNoUnrefHier, this.mName, XQEIntegerPool.getInteger(node.getId()).toString());
        }
        this.traceNodeCondition(true, "There is an unreferenced hierarchy available that can be used to create a calculated member on the DimensionLine.", trace);
        return true;
    }

    public boolean isReaggregationForOtherDetailFiltersAndSlicersDone(MDXQuery mdxQuery, XQETrace trace) {
        if (mdxQuery.getDescendantsOfTypes(new int[]{1097, 1098, 1185}, false).length > 0) {
            this.traceNodeCondition(false, "There are TNodeSlicer nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        int[] types = new int[]{1093, 1193, 1094};
        IXQEQueryNode[] mDFTNodes = mdxQuery.getDescendantsOfTypes(types, false);
        for (int i = 0; i < mDFTNodes.length; ++i) {
            if (mDFTNodes[i].getPropertyValue("AggregationRequired") == Boolean.FALSE || mDFTNodes[i].getPropertyValue("AggregationRequired") == Boolean.TRUE && mDFTNodes[i].getPropertyValue("AggregationApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "There are TNodeMDFOnSingleHierarchy or TNodeMDFOnSingleUnrefHierarchy nodes in the query for which -aggregation has not yet been applied.", trace);
            return false;
        }
        return true;
    }
}

