/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class ApplyMDFOnSingleHierarchyToSet
extends Transformation {
    public ApplyMDFOnSingleHierarchyToSet() {
        this.mName = "Apply Member Detail Filter With Positive Condition On Single Hierarchy To Set.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1018};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        Integer filterId = ((TNodeApplyMDFOnSingleHierarchyToSet)node).getDetailFilterIds().remove(0);
        IXQEQueryNode detailFilter = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(filterId);
        AbstractMDXSet targetSet = (AbstractMDXSet)node.getChild(0);
        MDXLevelInfo targetSetLevelInfo = targetSet.getLevelInfo();
        CogMDXIn cogMDXIn = (CogMDXIn)detailFilter.getChild(0);
        AbstractMDXSet dfSet = (AbstractMDXSet)factory.deepCopyNode((AbstractMDXSet)cogMDXIn.getChild(1));
        dfSet = MDXBuilder.correlateSetToLevels((IXQENodeFactory)factory, dfSet, targetSetLevelInfo);
        MDXIntersect mdxIntersect = (MDXIntersect)factory.createNode(1038);
        mdxIntersect.setAll(true);
        targetSet.insertParent(mdxIntersect);
        mdxIntersect.addChild(dfSet);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode targetSet;
        XQENodeFactory factory = environment.getNodeFactory();
        XQETrace trace = environment.getTrace();
        List<Integer> detailFilterIds = ((TNodeApplyMDFOnSingleHierarchyToSet)node).getDetailFilterIds();
        if (detailFilterIds.size() == 0) {
            this.traceNodeCondition(false, "The TNodeApplyMDFOnSingleHierarchyToSet node has no remaining detail filter ids.", trace);
            return false;
        }
        IXQEQueryNode tNodeMemberDetailFilter = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(detailFilterIds.get(0));
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (tNodeMemberDetailFilter == null || !tNodeMemberDetailFilter.isAncestor(mdxQuery)) {
            node.throwInternalError("Internal Error.");
        }
        if (!(targetSet = node.getChild(0)).isOfCategory(1021)) {
            this.traceNodeCondition(false, "The target node is not an AbstractMDXSet instance.", trace);
            return false;
        }
        IXQEQueryNode memberDetailFilter = tNodeMemberDetailFilter.getChild(0);
        if (memberDetailFilter.getType() != 1029 || !((CogMDXIn)memberDetailFilter).validateChildCategories()) {
            this.traceNodeCondition(false, "The next detail filter is not a CogMDXIn node, or it is but has invalid operands.", trace);
            return false;
        }
        MDXHierInfo targetSetHierInfo = ((AbstractMDXSet)targetSet).getHierarchyInfo();
        MDXHierInfo detailFilterHierInfo = ((AbstractMDXSet)memberDetailFilter.getChild(0)).getHierarchyInfo();
        if (targetSetHierInfo.getNumProjectedHierarchies() != 1 || !targetSetHierInfo.compareProjectedHierarchies(detailFilterHierInfo)) {
            this.traceNodeCondition(false, "Either the target set does not project a single hierarchy, or the next detail filter does not filter the hierarchy projected by the target set.", trace);
            return false;
        }
        IXQEQueryNode[] tNodeORdMDFsOnDiffHiers = mdxQuery.getDescendantsOfType(1107, false);
        for (int i = 0; i < tNodeORdMDFsOnDiffHiers.length; ++i) {
            if (tNodeORdMDFsOnDiffHiers[i].getPropertyValue("DistributeORdMDFsOnDiffHiersToPreMDXFilteringSetsApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The query contains TNodeApplyORdMDFsOnDiffHiersToSet nodes that have not yet been distributed to all parts of the query.", trace);
            return false;
        }
        IXQEQueryNode[] tNodeVDFs = mdxQuery.getDescendantsOfType(1095, false);
        for (int i = 0; i < tNodeVDFs.length; ++i) {
            if (tNodeVDFs[i].getPropertyValue("DistributeVDFToPreMDXFilteringSets") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The query contains TNodeValueDetailFilter nodes that have not yet been distributed to all parts of the query.", trace);
            return false;
        }
        if (mdxQuery.getDescendantsOfTypes(new int[]{1097, 1185}, true).length > 0) {
            this.traceNodeCondition(false, "The query contains slicers on unprojected hierarchies that must be resolved.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The next detail filter is applicable.", trace);
        return true;
    }
}

