/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import java.util.Iterator;
import java.util.List;

public class BuildAggrForMDF
extends Transformation {
    public BuildAggrForMDF() {
        this.mName = "Build Aggregation For Member Detail Filter.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXSet dfSet;
        MDXLevelInfo dfLevelInfo;
        ILevel highestLevel;
        MDXHierInfo dfHierInfo;
        IHierarchy dfHierarchy;
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedMDFsOnHierarchy(mdxQuery, dfHierarchy = (dfHierInfo = ((AbstractMDXSet)node.getChild(0).getChild(0)).getHierarchyInfo()).getProjectedHierarchy(0));
        if (tNodes.size() == 1 && (highestLevel = (dfLevelInfo = (dfSet = (AbstractMDXSet)node.getChild(0).getChild(1)).getLevelInfo()).getHighestProjectedLevel(dfHierarchy)) == dfLevelInfo.getLowestProjectedLevel(dfHierarchy)) {
            node.setPropertyValue("HighestAggregationLevel", highestLevel.getIndex());
        }
        dfSet = DFSLAggrUtil.generateSingleMDFAggregationSet(factory, mdxQuery, dfHierarchy, tNodes);
        node.addChild(dfSet);
        Iterator<TNodeAbstractMDXNode> it = tNodes.iterator();
        while (it.hasNext()) {
            if (it.next() != node) continue;
            it.remove();
            break;
        }
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") == null) {
            this.traceNodeCondition(false, "The target TNodeMDFOnSingleHierarchy node has not yet been flagged as necessitating aggregation in the query.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationRequired") == Boolean.FALSE) {
            this.traceNodeCondition(false, "The query does not require aggregation for the target TNodeMDFOnSingleHierarchy node.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Aggregation has already been applied for the target TNodeMDFOnSingleHierarchy node.", trace);
            return false;
        }
        if (DFSLAggrUtil.getSingleMDFAggregationSet((TNodeMDFOnSingleHierarchy)node) != null) {
            this.traceNodeCondition(false, "Aggregation set has already been built for the target node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeMDFOnSingleHierarchy node are invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Aggregatoin for the member detail filter can be built.", trace);
        return true;
    }
}

