/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeApplyVDFToSet;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.Iterator;
import java.util.List;

public class BuildAggrForVDF
extends Transformation {
    public BuildAggrForVDF() {
        this.mName = "Build Aggregation For Value Detail Filter.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        List<TNodeAbstractMDXNode> tNodes = DFSLAggrUtil.getUnprocessedVDFs(mdxQuery);
        AbstractMDXBooleanExpression dfCond = DFSLAggrUtil.generateSingleVDFCondition(factory, tNodes);
        MDXLevelInfo queryProjLevelInfo = mdxQuery.getLevelInfo();
        AbstractMDXSet aggrSet = DFSLAggrUtil.constructVDFAggregationSet(factory, mdxQuery, queryProjLevelInfo);
        if (aggrSet == null) {
            MDXCurrentMember mdxCurrentMember = MDXBuilder.buildMDXCurrentMemberExpr(factory, mdxQuery.getMeasuresHierarchy());
            aggrSet = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, mdxCurrentMember);
        }
        node.addChild(dfCond);
        node.addChild(aggrSet);
        Iterator<TNodeAbstractMDXNode> it = tNodes.iterator();
        while (it.hasNext()) {
            if (it.next() != node) continue;
            it.remove();
            break;
        }
        DFSLAggrUtil.flagNodesWithAggregationApplied(tNodes);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") == null) {
            this.traceNodeCondition(false, "The target TNodeValueDetailFilter node has not yet been flagged as necessitating aggregation in the query.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationRequired") == Boolean.FALSE) {
            this.traceNodeCondition(false, "The query does not require an aggregation for the target TNodeValueDetailFilter node.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Aggregation has already been applied for the target TNodeValueDetailFilter node.", trace);
            return false;
        }
        if (((TNodeValueDetailFilter)node).getAggregationExpression() != null) {
            this.traceNodeCondition(false, "Aggregation has already been built for the target node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeValueDetailFilter node are invalid.", trace);
            return false;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        List<Integer> tnIds = ((TNodeValueDetailFilter)node).getTNodeApplyVDFSetIds();
        for (Integer tnId : tnIds) {
            IXQEQueryNode tNodeApplyVDFToSet = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(tnId);
            if (((TNodeApplyVDFToSet)tNodeApplyVDFToSet).getDetailFilterIds().size() <= 0) continue;
            this.traceNodeCondition(false, "The TNodeApplyVDFToSet still not completely processed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Aggregatoin for the value detail filter can be built.", trace);
        return true;
    }
}

