/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractSlicer;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.ReplaceTNodeTrueFalse;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.AddAggrForSLOnProjHierToSlicer;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AbstractAssignHierToCalcMemberInValueSet;
import java.util.List;

public final class DistributeSlicerToUnprojectedReferences
extends Transformation {
    public static final String PROPERTY_TRANSFORMATION_APPLIED = "DistributeSlicerToUnprojectedReferences";

    public DistributeSlicerToUnprojectedReferences() {
        this.mName = "Distribute Slicer to Unprojected Referneces.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1185};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeAbstractSlicer tNodeSlicer = (TNodeAbstractSlicer)node;
        XQENodeFactory factory = environment.getNodeFactory();
        MDXLevelInfo slicerLevelInfo = tNodeSlicer.getLevelInfo();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (tNodeSlicer.getChild(0).getType() == 1145) {
            MDXQuery query = (MDXQuery)tNodeSlicer.getAncestorOfCategory(1002);
            ReplaceTNodeTrueFalse.clearQuery(factory, query);
            AddAggrForSLOnProjHierToSlicer.emptySetInFilteringExpressionWarning(environment, tNodeSlicer.getOriginalExpression());
            return;
        }
        IHierarchy hierarchy = tNodeSlicer.getHierarchy();
        IXQEQueryNode[] tuples = mdxQuery.getDescendantsOfType(1069, false);
        List<IXQEQueryNode> referencedSetExpressions = mdxQuery.getDescendantsOfCategory(1021, false);
        for (IXQEQueryNode tuple : tuples) {
            MDXHierInfo hierInfo;
            MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)tuple.getAncestorOfType(1005);
            if (calcDef != null && calcDef.isNonDetailGroupBody() && (hierInfo = AbstractAssignHierToCalcMemberInValueSet.resolveMDXHierInfoForCalcDefinition(calcDef)).getNumProjectedHierarchies() != 0 && !hierInfo.projectsHierarchy(hierarchy)) continue;
            this.updateTuple((MDXTuple)tuple, tNodeSlicer, slicerLevelInfo, hierarchy, factory);
        }
        for (IXQEQueryNode set : referencedSetExpressions) {
            MDXHierInfo hierInfo;
            MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)set.getAncestorOfType(1005);
            if (calcDef != null && calcDef.isNonDetailGroupBody() && (hierInfo = AbstractAssignHierToCalcMemberInValueSet.resolveMDXHierInfoForCalcDefinition(calcDef)).getNumProjectedHierarchies() != 0 && !hierInfo.projectsHierarchy(hierarchy)) continue;
            this.updateSet((AbstractMDXSet)set, tNodeSlicer, hierarchy, factory);
        }
        tNodeSlicer.setPropertyValue(PROPERTY_TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    public void updateSet(AbstractMDXSet set, TNodeAbstractSlicer tNodeSlicer, IHierarchy hierarchy, IXQENodeFactory factory) {
        AbstractMDXSet slicerSet;
        MDXHierInfo hierInfo = set.getHierarchyInfo();
        if (!hierInfo.projectsHierarchy(hierarchy)) {
            return;
        }
        if (set.getAncestorOfCategory(1018) != null) {
            return;
        }
        if (!tNodeSlicer.getChild(0).isOfCategory(1021)) {
            slicerSet = (MDXSet)factory.createNode(1039);
            tNodeSlicer.getChild(0).insertParent(slicerSet);
        }
        slicerSet = (AbstractMDXSet)factory.deepCopyNode(tNodeSlicer.getChild(0));
        MDXLevelInfo setLevelInfo = set.getLevelInfo();
        MDXQuery mdxQuery = (MDXQuery)tNodeSlicer.getAncestorOfType(1002);
        ILevel lowestReferencedLevel = mdxQuery.getLowestReferencedLevel(hierarchy);
        slicerSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, slicerSet, lowestReferencedLevel);
        MDXCalculatedMemberReference cm = AddAggrForSLOnProjHierToSlicer.buildCalculation(slicerSet, setLevelInfo, lowestReferencedLevel, mdxQuery, tNodeSlicer, factory);
        AbstractMDXNode child = set;
        AbstractMDXNode parent = (AbstractMDXNode)child.getParent();
        int[] types = new int[]{1042, 1058, 1041, 1053, 1057};
        while (true) {
            if (child.isOfTypes(types) && child.getNumberChildren() > 1) {
                ((AbstractMDXNode)child.getChild(1)).addMemberToContext(factory, cm, true);
                if (child.getType() == 1041) {
                    ((AbstractMDXNode)child.getChild(2)).addMemberToContext(factory, cm, true);
                }
            }
            if (parent.isOfCategory(1003) || parent.isOfCategory(1004)) {
                parent.throwInternalError("Failed to add context");
            }
            if (!parent.isProjectedDescendant(child)) break;
            child = parent;
            parent = (AbstractMDXNode)parent.getParent();
        }
        if (parent.isOfCategories(new int[]{1060, 1100})) {
            int valueExpressionPosition = 1;
            if (parent.isOfCategory(1100)) {
                valueExpressionPosition = 2;
            }
            if (parent.getNumberChildren() == valueExpressionPosition + 1) {
                ((AbstractMDXNode)parent.getChild(valueExpressionPosition)).addMemberToContext(factory, cm, true);
            } else {
                IXQEQueryNode mdxValue = factory.createNode(1059);
                IXQEQueryNode mdxTuple = factory.createNode(1069);
                mdxTuple.addChild(factory.copyNode(cm));
                mdxValue.addChild(mdxTuple);
                parent.addChild(mdxValue);
            }
        } else if (parent.getType() == 1087) {
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            parent.getChild(0).insertParent(mdxCrossjoin);
            IXQEQueryNode memberCopy = factory.copyNode(cm);
            MDXSet memberSet = (MDXSet)factory.createNode(1039);
            memberSet.addChild(memberCopy);
            mdxCrossjoin.addChild(memberSet);
        }
    }

    public void updateTuple(MDXTuple tuple, TNodeAbstractSlicer tNodeSlicer, MDXLevelInfo slicerLevelInfo, IHierarchy hierarchy, IXQENodeFactory factory) {
        if (!tuple.isValueExpressionOperand()) {
            return;
        }
        MDXLevelInfo tupleLevelInfo = tuple.getLevelInfo();
        if (!tupleLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
            return;
        }
        if (tuple.getAncestorOfCategory(1018) != null) {
            return;
        }
        for (IXQEQueryNode child : tuple.getChildren()) {
            AbstractMDXMember member;
            if (child.getType() == 1076 || !(member = (AbstractMDXMember)child).getHierarchy().equals(hierarchy)) continue;
            if (!tNodeSlicer.getChild(0).isOfCategory(1021)) {
                MDXSet set = (MDXSet)factory.createNode(1039);
                tNodeSlicer.getChild(0).insertParent(set);
            }
            if (tNodeSlicer.getChild(0).getType() == 1039 && tNodeSlicer.getChild(0).getNumberChildren() == 1 && tNodeSlicer.getChild(0).getChild(0).isSameExpression(member, false)) {
                return;
            }
            AbstractMDXSet slicerSet = (AbstractMDXSet)factory.deepCopyNode(tNodeSlicer.getChild(0));
            MDXQuery mdxQuery = (MDXQuery)tNodeSlicer.getAncestorOfType(1002);
            ILevel lowestProjectedLevel = tupleLevelInfo.getLowestProjectedLevel(hierarchy);
            ILevel lowestReferencedLevel = slicerLevelInfo.getLowestProjectedLevel(hierarchy);
            if (lowestProjectedLevel.getIndex() > lowestReferencedLevel.getIndex()) {
                lowestReferencedLevel = lowestProjectedLevel;
            }
            slicerSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, slicerSet, lowestReferencedLevel);
            MDXCalculatedMemberReference cm = AddAggrForSLOnProjHierToSlicer.buildCalculation(slicerSet, tupleLevelInfo, lowestReferencedLevel, mdxQuery, tNodeSlicer, factory);
            if (tuple.getHierarchyInfo().projectsHierarchy(cm.getHierarchy())) {
                return;
            }
            tuple.addChild(cm);
            break;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getPropertyValue(PROPERTY_TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied to this node.", trace);
            return false;
        }
        String reaggregationHostName = DFSLAggrUtil.getReaggregationHostName((TNodeAbstractSlicer)node);
        if (reaggregationHostName == null || reaggregationHostName.compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The slicer is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        if (cogMDXDetailFilterNodes.length > 0) {
            this.traceNodeCondition(false, "The query contains CogMDXDetailFilter nodes that have not yet been categorized.", trace);
            return false;
        }
        if (mdxQuery.getDescendantsOfType(1097, false).length > 0) {
            this.traceNodeCondition(false, "The query contains slicers on unreferenced hierarchies.", trace);
            return false;
        }
        if (mdxQuery.getDescendantsOfType(1098, false).length > 0) {
            this.traceNodeCondition(false, "The query contains slicers on projected hierarchies.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation has not yet been applied to this node.", trace);
        return true;
    }
}

