/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;

public final class FlagApplyAggrForMDFToQuery
extends Transformation {
    public FlagApplyAggrForMDFToQuery() {
        this.mName = "Flag Apply Aggregation For Member Detail Filter To Query.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093, 1094};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean referencedHierarchy;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXLevelInfo mdfLevelInfo = ((AbstractMDXSet)node.getChild(0).getChild(1)).getLevelInfo();
        boolean bl = referencedHierarchy = node.getType() == 1093;
        if (DFSLAggrUtil.isAggrRequiredForMDF(mdxQuery, mdfLevelInfo, referencedHierarchy)) {
            node.setPropertyValue("AggregationRequired", Boolean.TRUE);
            if (referencedHierarchy) {
                boolean projDetailsOnly = DFSLAggrUtil.isAggrRequiredForMDFOnlyProjDetails(mdxQuery, mdfLevelInfo, referencedHierarchy);
                node.setPropertyValue("AggregationProjectedSet", projDetailsOnly);
            }
        } else {
            node.setPropertyValue("AggregationRequired", Boolean.FALSE);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") != null) {
            this.traceNodeCondition(false, "The AggregationRequired property has already been set on the target detail filter node.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        boolean allProcessed = DFSLAggrUtil.isAllDFEdgeFiltertingApplied(mdxQuery);
        if (!allProcessed) {
            this.traceNodeCondition(false, "There are still TNodeApplyMDFOnSingleHierarchyToSet, TNodeApplyVDFToSet, or TNodeApplyORdMDFsOnDiffHiersToSet nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The AggregationRequired property has not yet been set on the target detail filter node.", trace);
        return true;
    }
}

