/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import java.util.ArrayList;

public final class FlagApplyAggrForORdMDFsOnDiffHiersToQuery
extends Transformation {
    public FlagApplyAggrForORdMDFsOnDiffHiersToQuery() {
        this.mName = "Flag Apply Aggregation For ORd Member Detail Filters On Different Hiearchies To Query";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1107};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] cogMDXInNodes;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ArrayList<MDXLevelInfo> filteredSetsLevelInfo = new ArrayList<MDXLevelInfo>();
        MDXOr dfORCondition = (MDXOr)node.getChild(0);
        for (IXQEQueryNode cogMDXIn : cogMDXInNodes = dfORCondition.getDescendantsOfType(1029, false)) {
            if (!cogMDXIn.validateChildCategories()) {
                throw new XQERuntimeException();
            }
            AbstractMDXSet filterSet = (AbstractMDXSet)cogMDXIn.getChild(1);
            filteredSetsLevelInfo.add(filterSet.getLevelInfo());
        }
        if (DFSLAggrUtil.isAggrRequiredForORdMDFsOnDiffHiers(mdxQuery, filteredSetsLevelInfo.toArray(new MDXLevelInfo[filteredSetsLevelInfo.size()]))) {
            node.setPropertyValue("AggregationRequired", Boolean.TRUE);
            return;
        }
        node.setPropertyValue("AggregationRequired", Boolean.FALSE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") != null) {
            this.traceNodeCondition(false, "The AggregationRequired property has already been set on the target detail filter node.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        boolean allProcessed = DFSLAggrUtil.isAllDFEdgeFiltertingApplied(mdxQuery);
        if (!allProcessed) {
            this.traceNodeCondition(false, "There are still TNodeApplyMDFOnSingleHierarchyToSet, TNodeApplyVDFToSet, or TNodeApplyORdMDFsOnDiffHiersToSet nodes in the query that must be processed before this transformation can be applied.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the targetTNodeORdMDFsOnDiffHiers node are invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The AggregationRequired property has not yet been set on the target detail filter node.", trace);
        return true;
    }
}

