/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;
import java.util.Set;

public final class CastPostAAMDFOnSingleHierarchyToVDF
extends Transformation {
    public CastPostAAMDFOnSingleHierarchyToVDF() {
        this.mName = "Cast PostAA Member Detail Filter On Single Hierarchy to Value Detail Filter.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeMDFOnSingleHierarchy tNodeMDFOnSingleHierarchy = (TNodeMDFOnSingleHierarchy)node;
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXIn condition = (CogMDXIn)tNodeMDFOnSingleHierarchy.getChild(0);
        MDXQuery mdxQuery = (MDXQuery)tNodeMDFOnSingleHierarchy.getAncestorOfType(1002);
        MDXLevelInfo levelInfo = mdxQuery.getLevelInfo();
        MDXComparisonOperator compExpr = DFSLClassificationUtil.castCogMDXInToValue(factory, condition, levelInfo);
        condition.getParent().exchangeChildNode(condition, compExpr);
        TNodeValueDetailFilter tNode = (TNodeValueDetailFilter)factory.createNode(1095);
        DFSLClassificationUtil.copyProperties(tNodeMDFOnSingleHierarchy, tNode);
        tNodeMDFOnSingleHierarchy.exchange(tNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] vdfs = mdxQuery.getDescendantsOfTypes(new int[]{1095, 1108}, false);
        if (vdfs.length == 0) {
            this.traceNodeCondition(false, "No value detail filters.", trace);
            return false;
        }
        TNodeMDFOnSingleHierarchy tNode = (TNodeMDFOnSingleHierarchy)node;
        if (!tNode.getPostAutoAggregation()) {
            this.traceNodeCondition(false, "Detail filter timing is not post auto aggregation.", trace);
            return false;
        }
        if (!tNode.getPostAutoAggregationTiming(mdxQuery).equals("virtualDetails")) {
            this.traceNodeCondition(false, "Detail filter is not supposed to be applied to the virtual cube.", trace);
            return false;
        }
        IHierarchy hierarchy = tNode.getMDFHierarchy();
        for (IXQEQueryNode vdf : vdfs) {
            Set<IHierarchy> hierarchies = ((AbstractMDXNode)vdf).getReferencedHierarchies();
            if (!hierarchies.contains(hierarchy) && vdf.getDescendantsOfCategory(1138, false).isEmpty()) continue;
            this.traceNodeCondition(true, "Value detail filter references the same hierarchy as member filter. Target member filter node must be applied post auto aggregation as this causes a conflict.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Member detail filter does not need to be applied post auto aggregation", trace);
        return false;
    }
}

