/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleRefHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.Set;

public final class CastToMDFOnReferencedHierarchy
extends Transformation {
    public CastToMDFOnReferencedHierarchy() {
        this.mName = "Cast A MDF To Slicer On Projected Hierarchy.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)node;
        TNodeMDFOnSingleRefHierarchy tNodeMDF = (TNodeMDFOnSingleRefHierarchy)factory.createNode(1193);
        tNodeMDF.setOriginalExpression(cogMDXDetailFilter.getOriginalExpression());
        cogMDXDetailFilter.exchange(tNodeMDF, true);
        MDXQuery mdxQuery = (MDXQuery)tNodeMDF.getAncestorOfType(1002);
        AbstractMDXNode expression = (AbstractMDXNode)tNodeMDF.getChild(0).getChild(1);
        mdxQuery.updateCountOfMDFandSlicerByHierarchy(expression.getHierarchyInfo().getProjectedHierarchy(0));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean status = CastToMDFOnReferencedHierarchy.nodeCondition(node, traceMsg);
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        if (((CogMDXDetailFilter)node).pushDetailFilterToRelationalProvider()) {
            traceMsg.append("Detail filter pushed to the relational query, not applicable.");
            return false;
        }
        if (!node.validateChildCategories()) {
            if (traceMsg != null) {
                traceMsg.append("The cogMDXDetailFilter node has invalid child nodes.");
            }
            return false;
        }
        CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)node;
        if (cogMDXDetailFilter.getChild(0).getType() != 1029) {
            traceMsg.append("The child of the CogMDXDetailFilter node is not a CogMDXIn node.");
            return false;
        }
        CogMDXIn cogMDXIn = (CogMDXIn)node.getChild(0);
        if (!cogMDXIn.isNormalized()) {
            traceMsg.append("The CogMDXIn node has not yet been normalized by the NormalizeCogMDXIn transformation.");
            return false;
        }
        AbstractMDXSet leftFilterSet = (AbstractMDXSet)cogMDXDetailFilter.getChild(0).getChild(0);
        AbstractMDXSet rightFilterSet = (AbstractMDXSet)cogMDXDetailFilter.getChild(0).getChild(1);
        MDXHierInfo leftHierInfo = leftFilterSet.getHierarchyInfo();
        MDXHierInfo rightHierInfo = rightFilterSet.getHierarchyInfo();
        String filterTargetsMultipleHierarchies = "The cogMDXDetailFilter node does not target a single hierarchy.";
        if (leftHierInfo.getNumProjectedHierarchies() != 1 || rightHierInfo.getNumProjectedHierarchies() != 1) {
            if (traceMsg != null) {
                traceMsg.append("The cogMDXDetailFilter node does not target a single hierarchy.");
            }
            return false;
        }
        if (!leftHierInfo.getProjectedHierarchy(0).equals(rightHierInfo.getProjectedHierarchy(0))) {
            if (traceMsg != null) {
                traceMsg.append("The cogMDXDetailFilter node does not target a single hierarchy.");
            }
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy hierarchy = rightHierInfo.getProjectedHierarchy(0);
        MDXHierInfo projectedHierarchies = mdxQuery.getHierarchyInfo();
        if (projectedHierarchies.projectsHierarchy(hierarchy)) {
            if (traceMsg != null) {
                traceMsg.append("The cogMDXDetailFilter expression projects a hierarchy that is projected in one of the MDXEdge expressions of the MDXQuery.");
            }
            return false;
        }
        Set<IHierarchy> refHierarchies = mdxQuery.getReferencedHierarchiesOnEdges();
        if (refHierarchies.contains(hierarchy)) {
            if (traceMsg != null) {
                traceMsg.append("The cogMDXDetailFilter expression projects a hierarchy that is referenced in one or more of the MDXEdge expressions of the MDXQuery.");
            }
            return true;
        }
        if (traceMsg != null) {
            traceMsg.append("The cogMDXDetailFilter expression does not project a hierarchy that is referenced in any of the MDXEdge expressions in the MDXQuery.");
        }
        return false;
    }
}

