/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.CastToMDFOnReferencedHierarchy;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;

public final class CastToMDFOnSingleHierarchy
extends Transformation {
    public CastToMDFOnSingleHierarchy() {
        this.mName = "Cast To Member Detail Filter On Single Hierarchy.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node;
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeMDFOnSingleHierarchy tNode = (TNodeMDFOnSingleHierarchy)factory.createNode(1093);
        DFSLClassificationUtil.copyProperties(detailFilter, tNode);
        CogMDXIn cogMDXIn = (CogMDXIn)detailFilter.getChild(0);
        if (cogMDXIn.getCorrelatedHierarchies() != null) {
            tNode.addCorrelatedHierarchies(cogMDXIn.getCorrelatedHierarchies());
        }
        detailFilter.exchange(tNode, true);
        MDXQuery mdxQuery = (MDXQuery)tNode.getAncestorOfType(1002);
        AbstractMDXNode expression = (AbstractMDXNode)tNode.getChild(0).getChild(1);
        mdxQuery.updateCountOfMDFandSlicerByHierarchy(expression.getHierarchyInfo().getProjectedHierarchy(0));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((CogMDXDetailFilter)node).pushDetailFilterToRelationalProvider()) {
            this.traceQueryCondition(false, "Detail filter pushed to the relational query, not applicable.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The CogMDXDetailFilter node has invalid child nodes.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1029) {
            this.traceNodeCondition(false, "The child of the CogMDXDetailFilter node is not a CogMDXIn node.", trace);
            return false;
        }
        CogMDXIn cogMDXIn = (CogMDXIn)node.getChild(0);
        if (!cogMDXIn.isNormalized()) {
            this.traceNodeCondition(false, "The CogMDXIn node has not yet been normalized by the NormalizeCogMDXIn transformation.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((MDXMembers)cogMDXIn.getChild(0)).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The first child of the CogMDXIn node does not project a single hierarchy.", trace);
            return false;
        }
        if (CastToMDFOnReferencedHierarchy.nodeCondition(node, null)) {
            this.traceNodeCondition(false, "This node should be handled by CastToMDFOnReferencedHierarchy.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The detail filter condition is a CogMDXIn function on a single hierarchy.", trace);
        return true;
    }
}

