/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.TNodeORdMDFsOnDiffHiers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CastToORdMDFsOnDiffHiers
extends Transformation {
    public CastToORdMDFsOnDiffHiers() {
        this.mName = "Cast To ORd Member Detail Filter On Different Hierarchies.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] cogMDXInNodes;
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node;
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeORdMDFsOnDiffHiers tNode = (TNodeORdMDFsOnDiffHiers)factory.createNode(1107);
        DFSLClassificationUtil.copyProperties(detailFilter, tNode);
        for (IXQEQueryNode cogMDXInNode : cogMDXInNodes = detailFilter.getDescendantsOfType(1029, false)) {
            CogMDXIn cogMDXIn = (CogMDXIn)cogMDXInNode;
            if (cogMDXIn.getCorrelatedHierarchies() == null) continue;
            List<IHierarchy> correlatedHierarchies = cogMDXIn.getCorrelatedHierarchies();
            if (correlatedHierarchies.isEmpty()) {
                tNode.addCorrelatedHierarchy(null);
                continue;
            }
            for (IHierarchy correlatedHierarchy : correlatedHierarchies) {
                tNode.addCorrelatedHierarchy(correlatedHierarchy);
            }
        }
        detailFilter.exchange(tNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target CogMDXDetailFilter node are invalid.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXInNodes = node.getDescendantsOfType(1029, false);
        if (cogMDXInNodes.length == 0) {
            this.traceNodeCondition(false, "The CogMDXDetailFilter condition does not contain any CogMDXIn nodes.", trace);
            return false;
        }
        for (int i = 0; i < cogMDXInNodes.length; ++i) {
            if (((CogMDXIn)cogMDXInNodes[i]).isNormalized()) continue;
            this.traceNodeCondition(false, "The CogMDXDetailFilter condition contains a CogMDXIn node that has not yet been normalized by the NormalizeCogMDXIn transformation.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 1111) {
            boolean withExpectedChildren = true;
            MDXOr mdxOr = (MDXOr)node.getChild(0);
            AbstractMDXBooleanExpression[] orConditions = mdxOr.getAssociativeOperands(false);
            HashSet<IHierarchy> hierarchies = new HashSet<IHierarchy>();
            for (int i = 0; i < orConditions.length && withExpectedChildren; ++i) {
                AbstractMDXBooleanExpression condition = orConditions[i];
                if (condition.getType() == 1029) {
                    this.collectHierarchiesForCogMDXIn(condition, hierarchies);
                    continue;
                }
                if (condition.getType() == 1110) {
                    withExpectedChildren = this.collectHierarchiesForAndExpr(condition, hierarchies);
                    continue;
                }
                this.traceNodeCondition(false, "The CogMDXDetailFilter condition contains an OR condition that is not a CogMDXIn expression or an AND expression.", trace);
                return false;
            }
            if (!withExpectedChildren) {
                this.traceNodeCondition(false, "The CogMDXDetailFilter condition contains an OR condition that has child is not a CogMDXIn expression or and AND logical expression.", trace);
                return false;
            }
            if (hierarchies.size() > 1) {
                this.traceNodeCondition(true, "The CogMDXDetailFilter condition is a sequence of ORd CogMDXIn conditions in whichat least two of the CogMDXIn conditions filter different hierarchies.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The CogMDXDetailFilter condition is not a sequence of ORd CogMDXIn conditions in which at least two of the CogMDXIn conditions filter different hierarchies.", trace);
        return false;
    }

    private boolean collectHierarchiesForAndExpr(AbstractMDXBooleanExpression dfCondition, Set<IHierarchy> hierarchies) {
        if (dfCondition.getType() == 1029) {
            this.collectHierarchiesForCogMDXIn(dfCondition, hierarchies);
            return true;
        }
        if (dfCondition.getType() != 1110) {
            return false;
        }
        AbstractMDXBooleanExpression[] operands = ((MDXAnd)dfCondition).getAssociativeOperands(false);
        boolean withExpectedChildren = true;
        for (int i = 0; i < operands.length && withExpectedChildren; ++i) {
            withExpectedChildren = this.collectHierarchiesForAndExpr(operands[i], hierarchies);
        }
        return withExpectedChildren;
    }

    private void collectHierarchiesForCogMDXIn(AbstractMDXBooleanExpression dfCondition, Set<IHierarchy> hierarchies) {
        CogMDXIn cogMDXIn = (CogMDXIn)dfCondition;
        if (!cogMDXIn.isNormalized()) {
            throw new XQERuntimeException();
        }
        MDXHierInfo hierInfo = ((AbstractMDXSet)cogMDXIn.getChild(0)).getHierarchyInfo();
        hierarchies.add(hierInfo.getProjectedHierarchy(0));
    }
}

