/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;

public final class CastToValueDetailFilter
extends Transformation {
    public CastToValueDetailFilter() {
        this.mName = "Cast To Value Detail Filter.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node;
        XQENodeFactory factory = environment.getNodeFactory();
        TNodeValueDetailFilter tNode = (TNodeValueDetailFilter)factory.createNode(1095);
        DFSLClassificationUtil.copyProperties(detailFilter, tNode);
        detailFilter.exchange(tNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((CogMDXDetailFilter)node).pushDetailFilterToRelationalProvider()) {
            this.traceQueryCondition(false, "Detail filter pushed to the relational query, not applicable.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The CogMDXDetailFilter node has invalid child nodes.", trace);
            return false;
        }
        if (!((AbstractMDXBooleanExpression)node.getChild(0)).isConditionsOnValueExpressions()) {
            this.traceNodeCondition(false, "The detail filter condition is not a value comparison or a logical expression that is a combination of value comparisons.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.getDescendantsOfType(1095, false).length > 0) {
            this.traceNodeCondition(false, "The query already contains a TNodeValueDetailFilter node.  Multiple CogMDXDetailFilter nodes with conditions on value expressions should be been merged by the MergeValueDetailFilters transformation.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The detail filter condition is a value comparison or a logical expression that is a combination of value comparisons.", trace);
        return true;
    }
}

