/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;

public final class ConvertORdFilterToVDF
extends Transformation {
    public ConvertORdFilterToVDF() {
        this.mName = "Convert OR'd Filter to a Value Detail Filter.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1108, 1107};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeAbstractDetailFilter tNodeDetailFilter = (TNodeAbstractDetailFilter)node;
        XQENodeFactory factory = environment.getNodeFactory();
        MDXOr mdxOr = (MDXOr)tNodeDetailFilter.getChild(0);
        AbstractMDXBooleanExpression[] orConditions = mdxOr.getAssociativeOperands(false);
        MDXQuery mdxQuery = (MDXQuery)tNodeDetailFilter.getAncestorOfType(1002);
        MDXLevelInfo levelInfo = mdxQuery.getLevelInfo();
        for (int i = 0; i < orConditions.length; ++i) {
            AbstractMDXBooleanExpression condition = orConditions[i];
            if (condition.getType() != 1029) continue;
            MDXComparisonOperator compExpr = DFSLClassificationUtil.castCogMDXInToValue(factory, (CogMDXIn)condition, levelInfo);
            condition.getParent().exchangeChildNode(condition, compExpr);
        }
        TNodeValueDetailFilter tNode = (TNodeValueDetailFilter)factory.createNode(1095);
        DFSLClassificationUtil.copyProperties(tNodeDetailFilter, tNode);
        tNodeDetailFilter.exchange(tNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getType() == 1108) {
            this.traceNodeCondition(true, "Node is detail filter between MDFs and VDFs.", trace);
            return true;
        }
        TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
        if (tNode.getPostAutoAggregation()) {
            this.traceNodeCondition(true, "OR MDF between different hierarchies with a PostAA timing should be treated as VDFs.", trace);
            return true;
        }
        this.traceNodeCondition(true, "OR filter does not need to be coverted to a value detail filter.", trace);
        return false;
    }
}

