/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class ApplyAbsorptionLaws
extends Transformation {
    public ApplyAbsorptionLaws() {
        this.mName = "Apply Boolean Absorption Laws.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{1110, 1111};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        AbstractMDXBooleanExpression[] operands = null;
        operands = parent.getType() == 1111 ? ((MDXOr)parent).getAssociativeOperands(false) : ((MDXAnd)parent).getAssociativeOperands(false);
        for (int i = 0; i < operands.length; ++i) {
            if (operands[i] == node) continue;
            for (int j = 0; j < node.getNumberChildren(); ++j) {
                AbstractMDXBooleanExpression child = (AbstractMDXBooleanExpression)node.getChild(j);
                if (child.isLogicallyEquivalent(operands[i])) {
                    parent.detachChild(node);
                    parent.extract();
                    return;
                }
                if (child.getType() == 1111 && operands[i].getType() == 1111) {
                    List<AbstractMDXBooleanExpression> otherOROperands = ((MDXOr)operands[i]).getAssociativeOperandsInSubtree(false);
                    AbstractMDXBooleanExpression[] thisOROperands = ((MDXOr)child).getAssociativeOperands(true);
                    if (!this.isBooleanExprSubset(otherOROperands.toArray(new AbstractMDXBooleanExpression[otherOROperands.size()]), thisOROperands)) continue;
                    parent.detachChild(node);
                    parent.extract();
                    return;
                }
                if (child.getType() != 1110 || operands[i].getType() != 1110) continue;
                List<AbstractMDXBooleanExpression> otherANDOperands = ((MDXAnd)operands[i]).getAssociativeOperandsInSubtree(false);
                AbstractMDXBooleanExpression[] thisANDOperands = ((MDXAnd)child).getAssociativeOperands(true);
                if (!this.isBooleanExprSubset(otherANDOperands.toArray(new AbstractMDXBooleanExpression[otherANDOperands.size()]), thisANDOperands)) continue;
                parent.detachChild(node);
                parent.extract();
                return;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1010) == null) {
            this.traceNodeCondition(false, "The MDXOr node is not a descendant of a CogMDXDetailFilter node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target node are invalid.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent == null || parent.getType() != 1110 && parent.getType() != 1111) {
            this.traceNodeCondition(false, "The parent of the target node is not an MDXAnd or MDXOr node.", trace);
            return false;
        }
        if (parent.getType() == node.getType()) {
            this.traceNodeCondition(false, "The parent node is the same type as the target node.", trace);
            return false;
        }
        if (!parent.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the parent of the target node invalid.", trace);
            return false;
        }
        AbstractMDXBooleanExpression[] operands = null;
        operands = parent.getType() == 1111 ? ((MDXOr)parent).getAssociativeOperands(false) : ((MDXAnd)parent).getAssociativeOperands(false);
        boolean status = false;
        for (int i = 0; i < operands.length; ++i) {
            if (operands[i] == node) continue;
            for (int j = 0; j < node.getNumberChildren(); ++j) {
                AbstractMDXBooleanExpression child = (AbstractMDXBooleanExpression)node.getChild(j);
                if (child.isLogicallyEquivalent(operands[i])) {
                    status = true;
                    continue;
                }
                if (child.getType() == 1111 && operands[i].getType() == 1111) {
                    List<AbstractMDXBooleanExpression> otherOROperands = ((MDXOr)operands[i]).getAssociativeOperandsInSubtree(false);
                    AbstractMDXBooleanExpression[] thisOROperands = ((MDXOr)child).getAssociativeOperands(true);
                    if (!this.isBooleanExprSubset(otherOROperands.toArray(new AbstractMDXBooleanExpression[otherOROperands.size()]), thisOROperands)) continue;
                    status = true;
                    continue;
                }
                if (child.getType() != 1110 || operands[i].getType() != 1110) continue;
                List<AbstractMDXBooleanExpression> otherANDOperands = ((MDXAnd)operands[i]).getAssociativeOperandsInSubtree(false);
                AbstractMDXBooleanExpression[] thisANDOperands = ((MDXAnd)child).getAssociativeOperands(true);
                if (!this.isBooleanExprSubset(otherANDOperands.toArray(new AbstractMDXBooleanExpression[otherANDOperands.size()]), thisANDOperands)) continue;
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(true, "The transformation is applicable to the target node.", trace);
        } else {
            this.traceNodeCondition(false, "The transformation is not applicable to the target node.", trace);
        }
        return status;
    }

    private boolean isBooleanExprSubset(AbstractMDXBooleanExpression[] subset, AbstractMDXBooleanExpression[] superset) {
        for (int i = 0; i < subset.length; ++i) {
            if (this.containsLogicallyEquivalentBooleanExpr(superset, subset[i])) continue;
            return false;
        }
        return true;
    }

    private boolean containsLogicallyEquivalentBooleanExpr(AbstractMDXBooleanExpression[] listOfBoolExpr, AbstractMDXBooleanExpression boolExpr) {
        for (int i = 0; i < listOfBoolExpr.length; ++i) {
            if (!listOfBoolExpr[i].isLogicallyEquivalent(boolExpr)) continue;
            return true;
        }
        return false;
    }
}

