/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ApplyIdempotentLaws
extends Transformation {
    public ApplyIdempotentLaws() {
        this.mName = "Apply Boolean Idempotent Laws.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{1110, 1111};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode operandToRemove = node.getChild(0);
        if (node.getType() == 1110) {
            if (!((MDXAnd)node).isOperandRedundant(operandToRemove)) {
                operandToRemove = node.getChild(1);
            }
        } else if (!((MDXOr)node).isOperandRedundant(operandToRemove)) {
            operandToRemove = node.getChild(1);
        }
        node.detachChild(operandToRemove);
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1010) == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of a CogMDXDetailFilter node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target node are invalid.", trace);
            return false;
        }
        if (node.getType() == 1110) {
            if (((MDXAnd)node).isOperandRedundant(node.getChild(0))) {
                this.traceNodeCondition(true, "The first child condition of the target MDXAnd node is redundant and can be removed.", trace);
                return true;
            }
            if (((MDXAnd)node).isOperandRedundant(node.getChild(1))) {
                this.traceNodeCondition(true, "The second child condition of the target MDXAnd node is redundant and can be removed.", trace);
                return true;
            }
        } else {
            if (((MDXOr)node).isOperandRedundant(node.getChild(0))) {
                this.traceNodeCondition(true, "The first child condition of the target MDXOr node is redundant and can be removed.", trace);
                return true;
            }
            if (((MDXOr)node).isOperandRedundant(node.getChild(1))) {
                this.traceNodeCondition(true, "The second child condition of the target MDXOr node is redundant and can be removed.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "Both of the target node child conditions are required.", trace);
        return false;
    }
}

