/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5exptomdxexp.ConvertV5InExpressionOnPropertyToMDX;

public class CoercePropertyComparisonToCogMDXIn
extends Transformation {
    private static final int[] VALUE_FUNCTION_TYPES = new int[]{1144, 1149, 1084, 1155};

    public CoercePropertyComparisonToCogMDXIn() {
        this.mName = "Coerce a EQ comparison to a MDXProperties node within a CogMDXDetailFilter into a MDXFilter node.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXComparisonOperator comparison = (MDXComparisonOperator)node;
        comparison.setConvertToCogMDXIn(true);
        CogMDXIn cogMDXInNode = (CogMDXIn)nodeFactory.createNode(1029);
        comparison.getParent().exchangeChildNode(comparison, cogMDXInNode, false);
        CogMDXProperties mdxProperties = CoercePropertyComparisonToCogMDXIn.getCogMDXPropertiesNode(comparison.getChild(0));
        IHierarchy hierarchy = mdxProperties.getHierarchy();
        AbstractMDXNode context = (AbstractMDXNode)mdxProperties.detachChild(1);
        mdxProperties.addChild(MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, hierarchy));
        AbstractMDXSet set = null;
        set = context.isOfCategory(1022) ? MDXBuilder.buildMDXSetExpr((IXQENodeFactory)nodeFactory, (AbstractMDXMember)context) : (AbstractMDXSet)context;
        cogMDXInNode.addChild(nodeFactory.deepCopyNode(set));
        MDXFilter mdxFilter = null;
        mdxFilter = MDXBuilder.buildMDXFilterExpr(nodeFactory, set, comparison);
        cogMDXInNode.addChild(mdxFilter);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode cogMDXDetailFilter = node.getAncestorOfCategory(1010);
        boolean bl = status = cogMDXDetailFilter != null;
        if (trace.getTraceLevel() != 0) {
            String s2 = "within a CogMDXDetailFilter node.";
            StringBuilder msgStr = new StringBuilder("The node is");
            if (status) {
                msgStr.append(" ");
                msgStr.append(s2);
            } else {
                msgStr.append(" ");
                msgStr.append("not");
                msgStr.append(" ");
                msgStr.append(s2);
            }
            this.traceQueryCondition(status, msgStr.toString(), trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder msgStr = null;
        if (trace.getTraceLevel() != 0) {
            msgStr = new StringBuilder();
        }
        boolean status = CoercePropertyComparisonToCogMDXIn.nodeCondition(node, msgStr);
        if (msgStr != null) {
            this.traceNodeCondition(status, msgStr.toString(), trace);
        }
        return status;
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder msgStr) {
        boolean status = false;
        if (((MDXComparisonOperator)node).isConvertToCogMDXIn()) {
            if (msgStr != null) {
                msgStr.append("Comparison already converted to CogMDXIn");
            }
        } else {
            IXQEQueryNode parent = node.getParent();
            while (parent.isOfCategory(1071)) {
                parent = parent.getParent();
            }
            if (parent.getType() == 1010) {
                CogMDXProperties propertyNode = CoercePropertyComparisonToCogMDXIn.getCogMDXPropertiesNode(node.getChild(0));
                if (propertyNode == null) {
                    if (msgStr != null) {
                        msgStr.append("No CogMDXProperties node found in comparison");
                    }
                } else {
                    status = ConvertV5InExpressionOnPropertyToMDX.isPropertyComparison(node, msgStr, propertyNode);
                }
            } else if (msgStr != null) {
                msgStr.append("Parent of comparison not a detail filter.");
            }
        }
        return status;
    }

    private static CogMDXProperties getCogMDXPropertiesNode(IXQEQueryNode valueNode) {
        CogMDXProperties propertyNode = null;
        if (valueNode.getType() == 1016) {
            propertyNode = (CogMDXProperties)valueNode;
        } else if (valueNode.getType() == 1176) {
            propertyNode = CoercePropertyComparisonToCogMDXIn.getCogMDXPropertiesNode(valueNode.getChild(2));
        } else if (valueNode.isOfTypes(VALUE_FUNCTION_TYPES)) {
            IXQEQueryNode child;
            IXQEQueryNode[] iXQEQueryNodeArray = valueNode.getChildren();
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; i < n && (propertyNode = CoercePropertyComparisonToCogMDXIn.getCogMDXPropertiesNode(child = iXQEQueryNodeArray[i])) == null; ++i) {
            }
        }
        return propertyNode;
    }
}

