/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.normalization.OrderCogMDXNestNodesByHierarchyAndLevel;

public final class IsHierarchyDetailFilterCorrelationRequired
extends Transformation {
    public static final int HIERARCHY_NOT_PROJ = -1;
    public static final int PROJ_OTHER_THAN_HIERARCHY_MEMBER_OR_PROP = 1;
    public static final int PROJ_ONLY_HIERARCHY_MEMBER_OR_PROP = 0;

    public IsHierarchyDetailFilterCorrelationRequired() {
        this.mName = "Determines whether hierarchy detailFilter correlation is required.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1029};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean targetHierarchyIsProj;
        boolean isCogMDXProperty;
        CogMDXIn cogMDXIn = (CogMDXIn)node;
        IXQEQueryNode firstChild = cogMDXIn.getChild(0);
        boolean bl = isCogMDXProperty = cogMDXIn.getChild(0).getType() == 1016;
        if (isCogMDXProperty) {
            firstChild = cogMDXIn.getChild(0).getChild(1);
        }
        boolean membersOfHierarchy = firstChild.getType() == 1040 && firstChild.getChild(0).getType() == 1073;
        IHierarchy targetHierarchy = ((AbstractMDXSet)firstChild).getHierarchyInfo().getProjectedHierarchy(0);
        if (!membersOfHierarchy) {
            cogMDXIn.addCorrelatedHierarchy(targetHierarchy);
            return;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int[] types = new int[]{1027, 1026};
        IXQEQueryNode[] descendants = mdxQuery.getDescendantsOfTypes(types, false);
        int result = IsHierarchyDetailFilterCorrelationRequired.allProjectHierPropertyOrMembers(descendants, targetHierarchy, mdxQuery);
        boolean bl2 = targetHierarchyIsProj = result != -1;
        if (result == 1) {
            cogMDXIn.addCorrelatedHierarchy(targetHierarchy);
            return;
        }
        if (!targetHierarchyIsProj) {
            cogMDXIn.addCorrelatedHierarchy(targetHierarchy);
        } else {
            cogMDXIn.addCorrelatedHierarchy(null);
            int severityOfMessage = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_doNotCorrelateHDF, targetHierarchy.toString()));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXIn cogMDXIn = (CogMDXIn)node;
        if (cogMDXIn.getAncestorOfType(1010) == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of a CogMDXDetailFilter node.", trace);
            return false;
        }
        if (cogMDXIn.getCorrelatedHierarchies() != null) {
            this.traceNodeCondition(false, "The transformation has already been applied to this node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation needs to be applied.", trace);
        return true;
    }

    public static int allProjectHierPropertyOrMembers(IXQEQueryNode[] nestAndGroupList, IHierarchy targetHierarchy, MDXQuery mdxQuery) {
        boolean targetHierarchyIsProj = false;
        for (IXQEQueryNode descendant : nestAndGroupList) {
            boolean projMembersOfHierarchy;
            AbstractMDXSet abstractMDXSet = (AbstractMDXSet)descendant;
            if (!OrderCogMDXNestNodesByHierarchyAndLevel.isProjected(abstractMDXSet) || !(abstractMDXSet = (AbstractMDXSet)abstractMDXSet.getChild(0)).getHierarchyInfo().projectsHierarchy(targetHierarchy) || !mdxQuery.isProjectedDescendant(abstractMDXSet)) continue;
            targetHierarchyIsProj = true;
            if (abstractMDXSet.isOfCategories(new int[]{1058, 1117})) {
                abstractMDXSet = (AbstractMDXSet)abstractMDXSet.getChild(0);
            }
            if (abstractMDXSet.getType() == 1039 && abstractMDXSet.getNumberChildren() == 1 && abstractMDXSet.getChild(0).getType() == 1013) continue;
            boolean bl = projMembersOfHierarchy = abstractMDXSet.getType() == 1040 && abstractMDXSet.getChild(0).getType() == 1073;
            if (projMembersOfHierarchy) continue;
            return 1;
        }
        if (!targetHierarchyIsProj) {
            return -1;
        }
        return 0;
    }
}

