/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class MergePropertyCogMDXInConditions
extends Transformation {
    public MergePropertyCogMDXInConditions() {
        this.mName = "Merge Property CogMDXIn Conditions.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1029};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXHierInfo hierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        CogMDXIn target = this.findMergeTargetForPropertyCogMDXInCondition((CogMDXIn)node, hierarchy, factory);
        MDXFilter targetFilter = this.getMDXFilter(target);
        MDXFilter nodeFilter = this.getMDXFilter(node);
        IXQEQueryNode propertyComparison = nodeFilter.detachChild(1);
        IXQEQueryNode mdxAnd = factory.createNode(1110);
        targetFilter.getChild(1).insertParent(mdxAnd);
        mdxAnd.addChild(propertyComparison);
        IXQEQueryNode parent = node.getParent();
        node.detach();
        parent.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((CogMDXIn)node).isNormalized()) {
            this.traceNodeCondition(false, "The target CogMDXIn node has not yet been normalized by the NormalizeCogMDXIn transformation.", trace);
            return false;
        }
        if (node.getParent().getType() != 1010) {
            this.traceNodeCondition(false, "The parent of the target CogMDXIn node is not an MDXOr node.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXInNodes = node.getDescendantsOfType(1029, false);
        for (int i = 0; i < cogMDXInNodes.length; ++i) {
            if (((CogMDXIn)cogMDXInNodes[i]).isNormalized()) continue;
            this.traceNodeCondition(false, "The ancestor CogMDXDetailFilter node condition contains a CogMDXIn node that has not yet been normalized by the NormalizeCogMDXIn transformation.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXIn node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1040 || node.getChild(0).getChild(0).getType() != 1073) {
            this.traceNodeCondition(false, "The first operand of the CogMDXIn node is not an MDXMembers function on a base hierarchy.  NormalizeCogMDXIn must be applied to the target CogMDXIn node before thistransformation can be applied.", trace);
            return false;
        }
        MDXFilter nodeFilter = this.getMDXFilter(node);
        if (nodeFilter == null) {
            this.traceNodeCondition(false, "The second operand of the CogMDXIn node is not an MDXIntersect(...MDXFilter())", trace);
            return false;
        }
        if (nodeFilter.getChild(1).getDescendantsOfType(1016, true).length == 0) {
            this.traceNodeCondition(false, "MDXDistinct(MDXFilter()) OR MDXFilter() for a property.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        CogMDXIn target = this.findMergeTargetForPropertyCogMDXInCondition((CogMDXIn)node, hierarchy, null);
        if (target != null) {
            this.traceNodeCondition(true, "Found another CogMDXIn in the current OR condition chain to merge the given one.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Unable to locate another CogMDXIn condition to merge the target node with in the current OR condition chain.", trace);
        return false;
    }

    private CogMDXIn findMergeTargetForPropertyCogMDXInCondition(CogMDXIn cogMDXIn, IHierarchy hierarchy, IXQENodeFactory factory) {
        IXQEQueryNode[] detailFilters;
        MDXFilter filterNode = this.getMDXFilter(cogMDXIn);
        MDXLevelInfo filterLevelInfo = filterNode.getLevelInfo();
        if (!hierarchy.isParentChild() && filterLevelInfo.getNumProjectedLevels(hierarchy) > 1) {
            return null;
        }
        ILevel filterLowestLevel = filterLevelInfo.getLowestProjectedLevel(hierarchy);
        int filterLowestLevelIndex = filterLowestLevel.getIndex();
        MDXQuery mdxQuery = (MDXQuery)cogMDXIn.getAncestorOfType(1002);
        CogMDXIn targetCogMDXInFinal = null;
        AbstractMDXNode targetFilterFinal = null;
        for (IXQEQueryNode df : detailFilters = mdxQuery.getDescendantsOfType(1010, false)) {
            CogMDXIn targetCogMDXIn;
            MDXFilter targetFilter;
            IXQEQueryNode target = df.getChild(0);
            if (target.getType() != 1029 || target == cogMDXIn || !((CogMDXIn)target).isNormalized() || target.getDescendantsOfType(1016, false).length <= 0 || ((AbstractMDXSet)target.getChild(0)).getHierarchyInfo().getProjectedHierarchy(0) != hierarchy || (targetFilter = this.getMDXFilter(target)) == null || (targetCogMDXIn = (CogMDXIn)target) == null) continue;
            CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)cogMDXIn.getParent();
            CogMDXDetailFilter targetDetailFilter = (CogMDXDetailFilter)targetCogMDXIn.getParent();
            if (cogMDXDetailFilter.getPostAutoAggregation() != targetDetailFilter.getPostAutoAggregation()) continue;
            MDXLevelInfo targetLevelInfo = targetFilter.getLevelInfo();
            int targetLowestLevelIndex = targetLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
            if (!hierarchy.isParentChild() && targetLevelInfo.getNumProjectedLevels(hierarchy) > 1 || filterLowestLevelIndex > targetLowestLevelIndex) continue;
            if (targetFilterFinal != null) {
                MDXLevelInfo finalLevelInfo = targetFilterFinal.getLevelInfo();
                int finalLowestLevelIndex = finalLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
                if (finalLowestLevelIndex >= targetLowestLevelIndex) continue;
                targetCogMDXInFinal = targetCogMDXIn;
                targetFilterFinal = targetFilter;
                continue;
            }
            targetCogMDXInFinal = targetCogMDXIn;
            targetFilterFinal = targetFilter;
        }
        if (targetFilterFinal != null) {
            MDXLevelInfo targetLevelInfo = targetFilterFinal.getLevelInfo();
            int targetLowestLevelIndex = targetLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
            if (factory != null && !hierarchy.isParentChild() && filterLowestLevelIndex < targetLowestLevelIndex) {
                IXQEQueryNode[] cogMDXPropertiesInMergedFilter;
                for (IXQEQueryNode currProperties : cogMDXPropertiesInMergedFilter = cogMDXIn.getDescendantsOfType(1016, true)) {
                    AbstractMDXNode currPropertiesSecondChild = (AbstractMDXNode)currProperties.getChild(1);
                    if (currPropertiesSecondChild.getType() == 1043) continue;
                    IXQEQueryNode ancestor = factory.createNode(1043);
                    IXQEQueryNode levelNode = factory.createNode(1065);
                    ((BaseLevel)levelNode).bind(filterLowestLevel);
                    currPropertiesSecondChild.insertParent(ancestor);
                    ancestor.addChild(levelNode);
                }
            }
        }
        return targetCogMDXInFinal;
    }

    private MDXFilter getMDXFilter(IXQEQueryNode cogMDXIn) {
        IXQEQueryNode childNode = cogMDXIn.getChild(1);
        if (childNode.getType() == 1038) {
            childNode = childNode.getChild(1);
        } else if (childNode.getType() == 1033) {
            childNode = childNode.getChild(0);
        }
        if (childNode.getType() != 1053) {
            return null;
        }
        return (MDXFilter)childNode;
    }
}

