/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class RemoveUselessPostAAOrFilters
extends Transformation {
    private static final String THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED = "The transformation does not need to be applied.";

    public RemoveUselessPostAAOrFilters() {
        this.mName = "Removes useless post auto aggregate OR filters.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1111};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        int aSeverity = 1;
        environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PAAORDetailFilterProjNonFactNotInSingleEdgePath, detailFilter.getOriginalExpression()));
        detailFilter.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.isListReport()) {
            this.traceNodeCondition(false, "The query is for a list report.", trace);
            return false;
        }
        if (mdxQuery.isRelationaCrosstab()) {
            this.traceNodeCondition(false, "The query is for a relational crosstab.", trace);
            return false;
        }
        MDXOr mdxOr = (MDXOr)node;
        if (mdxOr.getAncestorOfType(1010) == null) {
            this.traceNodeCondition(false, "The target node is not a child of a CogMDXDetailFilter node.", trace);
            return false;
        }
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)mdxOr.getAncestorOfType(1010);
        if (!detailFilter.getPostAutoAggregation()) {
            this.traceNodeCondition(false, "The target node is not within a post auto aggregate CogMDXDetailFilter node.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXIns = mdxOr.getChildrenOfCategory(1029);
        if (cogMDXIns.length < 2) {
            this.traceNodeCondition(false, THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED, trace);
            return false;
        }
        ArrayList<IXQEQueryNode> oredCogMDXIns = new ArrayList<IXQEQueryNode>();
        oredCogMDXIns.addAll(Arrays.asList(cogMDXIns));
        IXQEQueryNode parent = mdxOr.getParent();
        while (parent.getType() != 1010) {
            if (parent.getType() != 1111) {
                this.traceNodeCondition(false, THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED, trace);
                return false;
            }
            cogMDXIns = parent.getChildrenOfCategory(1029);
            if (cogMDXIns.length == 0) {
                this.traceNodeCondition(false, THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED, trace);
                return false;
            }
            oredCogMDXIns.add(cogMDXIns[0]);
            parent = parent.getParent();
        }
        ArrayList<IHierarchy> correlatedHierarchies = null;
        for (IXQEQueryNode oredCogMDXIn : oredCogMDXIns) {
            CogMDXIn cogMDXIn = (CogMDXIn)oredCogMDXIn;
            if (cogMDXIn.getCorrelatedHierarchies() == null) {
                this.traceNodeCondition(false, "IsHierarchyDetailFilterCorrelationRequired has not been applied yet.", trace);
                return false;
            }
            if (cogMDXIn.getCorrelatedHierarchies().isEmpty()) continue;
            if (correlatedHierarchies == null) {
                correlatedHierarchies = new ArrayList<IHierarchy>();
            }
            if (correlatedHierarchies.containsAll(cogMDXIn.getCorrelatedHierarchies())) continue;
            correlatedHierarchies.addAll(cogMDXIn.getCorrelatedHierarchies());
        }
        if (correlatedHierarchies == null || correlatedHierarchies.size() == 1) {
            this.traceNodeCondition(false, THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED, trace);
            return false;
        }
        IXQEQueryNode[] mdxEdgeChildren = mdxQuery.getChildrenOfType(1006);
        boolean foundAffectedEdge = false;
        for (IXQEQueryNode mdxEdgeChild : mdxEdgeChildren) {
            MDXEdge mdxEdge = (MDXEdge)mdxEdgeChild;
            MDXHierInfo mdxEdgeHierInfo = mdxEdge.getHierarchyInfo();
            if (!mdxEdgeHierInfo.getProjectedHierarchies().containsAll(correlatedHierarchies)) continue;
            foundAffectedEdge = true;
            List<IXQEQueryNode> groups = mdxEdge.getDescendantsOfCategory(1027, false);
            for (IXQEQueryNode group : groups) {
                if (((CogMDXGroup)group).getNumberChildren() > 1) continue;
                int hierCount = 0;
                IHierarchy groupHier = ((CogMDXGroup)group).getFirstSetHierarchy();
                if (!((CogMDXGroup)group).isNormalizationGroup() && correlatedHierarchies.contains(groupHier)) {
                    ++hierCount;
                }
                for (IXQEQueryNode ancestorGroup = group.getAncestorOfCategory(1027); ancestorGroup != null; ancestorGroup = ancestorGroup.getAncestorOfCategory(1027)) {
                    if (((CogMDXGroup)ancestorGroup).isNormalizationGroup() || !correlatedHierarchies.contains(groupHier = ((CogMDXGroup)ancestorGroup).getFirstSetHierarchy())) continue;
                    ++hierCount;
                }
                if (hierCount != correlatedHierarchies.size()) continue;
                this.traceNodeCondition(false, THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED, trace);
                return false;
            }
            break;
        }
        if (!foundAffectedEdge) {
            this.traceNodeCondition(false, THE_TRANSFORMATION_DOES_NOT_NEED_TO_BE_APPLIED, trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation needs to be applied.", trace);
        return true;
    }
}

