/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashSet;

public final class WrapRelativeMemberInSet
extends Transformation {
    private int[] rmFnTypes = new int[]{1043, 1044, 1046};

    public WrapRelativeMemberInSet() {
        this.mName = "Wrap Relative Member In Set.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1093, 1094, 1107, 1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        IXQEQueryNode[] rmFns;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        HashSet<IHierarchy> invalidHierarchies = new HashSet<IHierarchy>();
        if (node.getType() == 1095) {
            invalidHierarchies.addAll(mdxQuery.getHierarchyInfo().getProjectedHierarchies());
        } else {
            IXQEQueryNode[] cogMDXInNodes = node.getDescendantsOfType(1029, false);
            for (int i = 0; i < cogMDXInNodes.length; ++i) {
                CogMDXIn cogMDXIn = (CogMDXIn)cogMDXInNodes[i];
                MDXHierInfo hierInfo = ((MDXMembers)cogMDXIn.getChild(0)).getHierarchyInfo();
                invalidHierarchies.add(hierInfo.getProjectedHierarchy(0));
            }
        }
        for (IXQEQueryNode rmFn : rmFns = mdxQuery.getDescendantsOfTypes(this.rmFnTypes, false)) {
            IXQEQueryNode tupleNode;
            IXQEQueryNode memberNode;
            MDXHierInfo rmHierInfo;
            if (rmFn.getAncestorOfTypes(this.mTypes) != null || !invalidHierarchies.contains((rmHierInfo = ((AbstractMDXNode)rmFn).getHierarchyInfo()).getProjectedHierarchy(0)) || ((AbstractMDXNode)rmFn).isContextDependent(rmHierInfo.getProjectedHierarchy(0)) || (memberNode = rmFn.getChild(0)).getType() == 1055 && (tupleNode = memberNode.getChild(0)).getType() == 1054) continue;
            IXQEQueryNode mdxSet = nodeFactory.createNode(1039);
            memberNode.insertParent(mdxSet);
            IXQEQueryNode mdxSetItem = nodeFactory.createNode(1054);
            mdxSet.insertParent(mdxSetItem);
            MDXNumericConstant mdxNumericValue = (MDXNumericConstant)nodeFactory.createNode(1064);
            mdxNumericValue.setConstantValue(XQEIntegerPool.getInteger(0));
            mdxSetItem.addChild(mdxNumericValue);
            IXQEQueryNode mdxTupleItem = nodeFactory.createNode(1055);
            mdxSetItem.insertParent(mdxTupleItem);
            mdxNumericValue = (MDXNumericConstant)nodeFactory.deepCopyNode(mdxNumericValue);
            mdxTupleItem.addChild(mdxNumericValue);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String timing;
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The target CogMDXDetailFilter node has invalid child nodes.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if ((node.getType() == 1093 || node.getType() == 1095) && (timing = ((TNodeAbstractDetailFilter)node).getPostAutoAggregationTiming(mdxQuery)).equals("reportDetails") && (node.getType() != 1093 || ((TNodeMDFOnSingleHierarchy)node).getPostAutoAggregation())) {
            this.traceNodeCondition(false, "The Detail Filter timing is set to 'reportDetails'", trace);
            return false;
        }
        IXQEQueryNode[] rmFns = mdxQuery.getDescendantsOfTypes(this.rmFnTypes, false);
        if (rmFns.length == 0) {
            this.traceNodeCondition(false, "The MDXQuery does not contain a relative member function which can be wrapped in a set.", trace);
            return false;
        }
        HashSet<IHierarchy> invalidHierarchies = new HashSet<IHierarchy>();
        if (node.getType() == 1095) {
            invalidHierarchies.addAll(mdxQuery.getHierarchyInfo().getProjectedHierarchies());
        } else {
            IXQEQueryNode[] cogMDXInNodes = node.getDescendantsOfType(1029, false);
            if (cogMDXInNodes.length == 0) {
                this.traceNodeCondition(false, "The target CogMDXDetailFilter node does not have any descendant CogMDXIn nodes.", trace);
                return false;
            }
            for (int i = 0; i < cogMDXInNodes.length; ++i) {
                CogMDXIn cogMDXIn = (CogMDXIn)cogMDXInNodes[i];
                MDXHierInfo hierInfo = ((MDXMembers)cogMDXIn.getChild(0)).getHierarchyInfo();
                invalidHierarchies.add(hierInfo.getProjectedHierarchy(0));
            }
        }
        for (IXQEQueryNode rmFn : rmFns) {
            IXQEQueryNode tupleNode;
            IXQEQueryNode memberNode;
            MDXHierInfo rmHierInfo;
            if (rmFn.getAncestorOfTypes(this.mTypes) != null || !invalidHierarchies.contains((rmHierInfo = ((AbstractMDXNode)rmFn).getHierarchyInfo()).getProjectedHierarchy(0)) || ((AbstractMDXNode)rmFn).isContextDependent(rmHierInfo.getProjectedHierarchy(0)) || (memberNode = rmFn.getChild(0)).getType() == 1055 && (tupleNode = memberNode.getChild(0)).getType() == 1054) continue;
            this.traceNodeCondition(true, "The MDXQuery uses a relative member function that will be affected by a detail filter condition.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDXQuery does not use any relative member functions that will be affected by a member detail filter condition.", trace);
        return false;
    }
}

