/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.sort;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.TNodeSort;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.ConvertLocalSortToXV5Sort;
import java.util.List;

public class ConvertMultiLevelSortToXV5Sort
extends Transformation {
    public static final String STRING_NAME = "name";
    public static final String STRING_REFDATAITEM = "refDataItem";
    public static final String STRING_DESCENDING = "descending";

    public ConvertMultiLevelSortToXV5Sort() {
        this.mName = "Convert MultiLevel TNodeSort To XV5Sort";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{1117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        int edgeNum = edge.getEdgeID();
        CogMDXReportSummary.updateRefSummary(node, node.getChild(0));
        ConvertLocalSortToXV5Sort.convertTNodeSortToXV5Sort((TNodeSort)node, environment, edgeNum);
    }

    public boolean hasMultiLevelOrMultiHierarchyDataItems(IXQEQueryNode node) {
        List<IXQEQueryNode> nestNodes = node.getDescendantsOfTypeOrdered(1026, false);
        MDXLevelInfo contextLevelInfo = ((TNodeSort)node).getContextLevelInfo();
        MDXLevelInfo lastLevelInfo = null;
        for (CogMDXNest cogMDXNest : nestNodes) {
            MDXLevelInfo currLevelInfo = ((AbstractMDXSet)cogMDXNest.getChild(0)).getLevelInfo();
            if (currLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() > 1) {
                return true;
            }
            IHierarchy currHierarchy = currLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
            if (lastLevelInfo != null && currHierarchy.equals(lastLevelInfo.getHierarchyInfo().getProjectedHierarchy(0)) && lastLevelInfo.getNumProjectedLevels(currHierarchy) > 1) {
                return true;
            }
            if (contextLevelInfo.getHierarchyInfo().projectsHierarchy(currHierarchy)) {
                ILevel contextLevel = contextLevelInfo.getLowestProjectedLevel(currHierarchy);
                ILevel currentLevel = currLevelInfo.getHighestProjectedLevel(currHierarchy);
                if (contextLevel != null && currentLevel != null && contextLevel.getIndex() > currentLevel.getIndex()) {
                    return true;
                }
            }
            lastLevelInfo = currLevelInfo;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        if (cogMDXQueryNode == null) {
            this.traceQueryCondition(false, "The CogMDXGroup node is not a descendant of an MDXQuery node or not all detail, summary, and slicer filters have been applied.", trace);
            return false;
        }
        IXQEQueryNode[] sortItemNodes = node.getChildrenOfType(1118);
        if (sortItemNodes.length == 0) {
            this.traceNodeCondition(false, "The TNodeSort node does not have any TNodeSortItem child nodes.", trace);
            return false;
        }
        IXQEQueryNode[] summaries = node.getAncestorsOfType(1080);
        if (summaries.length != 0) {
            this.traceNodeCondition(false, "V5ValueSet is a descendant of a Report Summary", trace);
            return false;
        }
        if (!this.hasMultiLevelOrMultiHierarchyDataItems(node)) {
            this.traceNodeCondition(true, "GroupBody does not have multi-hierarchy or multi-level dataItems.", trace);
            return false;
        }
        this.traceNodeCondition(false, "Local sort processing required.", trace);
        return true;
    }
}

