/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.sort;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.MDXOrder;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeBuildTagTuple;
import com.cognos.xqe.ast.olap.TNodeSort;
import com.cognos.xqe.ast.olap.TNodeSortItem;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.sort.ConvertValueSortItemInNonDetailGroup;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class ConvertTNodeSortToMDXOrder
extends Transformation {
    public ConvertTNodeSortToMDXOrder() {
        this.mName = "Convert TNodeSort to MDXOrder.";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{1117};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        void var12_15;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Integer groupId = ((TNodeSort)node).getGroupId();
        CogMDXGroup group = (CogMDXGroup)nodeFactory.getNodeIndex().getNodeByID(groupId);
        AbstractMDXSet subtree = (AbstractMDXSet)node.getChild(0);
        AbstractMDXSet measureExpr = null;
        measureExpr = node.getChild(1).getType() == 1027 || node.getChild(1).getType() == 1026 ? (AbstractMDXSet)node.detachChild(1) : null;
        IXQEQueryNode[] sortItemNodes = node.getChildrenOfTypeOrdered(1118);
        for (int i = 0; i < sortItemNodes.length; ++i) {
            this.createOrderExpression(subtree, (TNodeSortItem)sortItemNodes[i], environment);
        }
        List<IXQEQueryNode> groupNodes = subtree.getDescendantsOfTypeOrdered(1027, true);
        for (CogMDXGroup cogMDXGroup : groupNodes) {
            cogMDXGroup.setProjectDetailsOnly();
        }
        this.createSortProjectionExpression((AbstractMDXSet)node.getChild(0), measureExpr, group, mdxQuery, environment);
        CogMDXReportSummary.updateRefSummary(node, node.getChild(0));
        boolean bl = false;
        while (var12_15 < sortItemNodes.length) {
            node.detachChild(sortItemNodes[var12_15]);
            ++var12_15;
        }
        node.extract();
    }

    private void createOrderExpression(AbstractMDXSet subtree, TNodeSortItem sortItem, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXNode sortExpr = (AbstractMDXNode)sortItem.detachChild(0);
        boolean isDescendingOrder = !sortItem.isOrderAscending();
        String nullsPlacement = (String)sortItem.getPropertyValue("nullsPlacement");
        MDXLevelInfo sortLevelInfo = sortExpr.getLevelInfo();
        AbstractMDXValueExpression orderExpr = null;
        if (sortLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() == 0) {
            orderExpr = MDXBuilder.coerceToValueExpression(sortExpr, nodeFactory);
        } else {
            IHierarchy sortHierarchy = sortLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
            if (!sortHierarchy.getDimension().isMeasuresDimension()) {
                MDXLevelInfo subtreeLevelInof = subtree.getLevelInfo();
                if (!subtreeLevelInof.getHierarchyInfo().projectsHierarchy(sortHierarchy)) {
                    return;
                }
                ILevel sortLevel = null;
                orderExpr = (CogMDXProperties)nodeFactory.createNode(1016);
                BaseProperty orderProperty = null;
                if (sortExpr.getType() != 1016) {
                    orderProperty = (BaseProperty)nodeFactory.createNode(1025);
                    orderProperty.bind(RoleTypeEnum.MEMBER_CAPTION, null, null);
                    sortLevel = sortLevelInfo.getLowestProjectedLevel(sortHierarchy);
                } else {
                    orderProperty = (BaseProperty)sortExpr.detachChild(0);
                    IQueryItem orderItem = orderProperty.getPropertyMetadata();
                    if (orderItem != null) {
                        sortLevel = orderItem.getLevel();
                    } else if (sortItem.getMetadata() instanceof ILevel) {
                        sortLevel = (ILevel)sortItem.getMetadata();
                    }
                }
                if (sortLevel != null && sortLevel.compareTo(subtree.getLevelInfo().getLowestProjectedLevel(sortHierarchy)) == 0) {
                    sortLevel = null;
                }
                orderExpr.addChild(orderProperty);
                orderExpr.addChild(MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, sortHierarchy, sortLevel));
            } else {
                orderExpr = MDXBuilder.coerceToValueExpression(sortExpr, nodeFactory);
            }
        }
        MDXOrder mdxOrder = (MDXOrder)nodeFactory.createNode(1058);
        subtree.insertParent(mdxOrder);
        if (isDescendingOrder) {
            mdxOrder.setOrderingProperty(3);
        } else {
            mdxOrder.setOrderingProperty(1);
        }
        if (nullsPlacement != null) {
            mdxOrder.setPropertyValue("nullsPlacement", nullsPlacement);
        }
        mdxOrder.addChild(orderExpr);
    }

    private void createSortProjectionExpression(AbstractMDXSet orderExpr, AbstractMDXSet measureExpr, CogMDXGroup group, MDXQuery mdxQuery, PlanningEnvironment environment) {
        MDXSet mdxSet;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ICube cube = mdxQuery.getReferencedCube();
        IHierarchy measureHierarchy = cube.getMeasuresHierarchy();
        MDXHierInfo hierarchyInfo = orderExpr.getHierarchyInfo();
        int numHierarchy = hierarchyInfo.getNumProjectedHierarchies();
        int iHierarchy = 0;
        MDXSet mdxSet2 = mdxSet = (MDXSet)nodeFactory.createNode(1039);
        boolean bUseCrossjoin = true;
        MDXLevelInfo lastLevelInfo = null;
        while (group != null) {
            MDXLevelInfo currLevelInfo = ((AbstractMDXSet)group.getChild(0)).getLevelInfo();
            IHierarchy currHierarchy = currLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
            if (lastLevelInfo != null) {
                IHierarchy lastHierarchy = lastLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
                if (group.getGenerateProjCurrentMember() && currHierarchy.equals(lastHierarchy)) {
                    ILevel level = lastLevelInfo.getProjectedLevel(lastHierarchy, 0);
                    MDXTuple mdxTuple = (MDXTuple)nodeFactory.createNode(1069);
                    mdxTuple.addChild(MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, lastHierarchy, level));
                    CogMDXGroup ancesotrGroup = (CogMDXGroup)group.getAncestorOfType(1027);
                    for (int h = iHierarchy + 1; h < numHierarchy; ++h) {
                        mdxTuple.addChild(MDXBuilder.buildMDXFillerExpr(nodeFactory, hierarchyInfo.getProjectedHierarchy(h), mdxQuery));
                    }
                    if (measureExpr != null) {
                        mdxTuple.addChild(MDXBuilder.buildMDXFillerExpr(nodeFactory, measureHierarchy, mdxQuery));
                        MDXSet fillerTagSet = (MDXSet)nodeFactory.createNode(1039);
                        mdxSet2.addChild(fillerTagSet);
                        fillerTagSet.addChild(mdxTuple);
                        fillerTagSet.setHierarchyNomalization(true);
                        fillerTagSet.setDoNotOptimizeMDXSetWithinMDXSet(true);
                    } else {
                        mdxSet2.addChild(mdxTuple);
                    }
                    bUseCrossjoin = false;
                } else {
                    MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)nodeFactory.createNode(1030);
                    mdxSet2.addChild(mdxCrossjoin);
                    mdxCrossjoin.addChild(MDXBuilder.buildMDXSetExpr((IXQENodeFactory)nodeFactory, MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, lastHierarchy, null)));
                    mdxSet2 = (MDXSet)nodeFactory.createNode(1039);
                    mdxCrossjoin.addChild(mdxSet2);
                    ++iHierarchy;
                }
            }
            lastLevelInfo = currLevelInfo;
            if (group.getTagType() == "firstTuple" || group.getTagType() == "eachTuple") {
                TNodeBuildTagTuple tNodeBuildTagTuple = (TNodeBuildTagTuple)nodeFactory.createNode(1124);
                tNodeBuildTagTuple.setTagType(group.getTagType());
                tNodeBuildTagTuple.setCogMDXGroup(group);
                for (int h = iHierarchy; h < hierarchyInfo.getNumProjectedHierarchies(); ++h) {
                    tNodeBuildTagTuple.addHierarchy(hierarchyInfo.getProjectedHierarchy(h));
                }
                if (measureExpr != null) {
                    tNodeBuildTagTuple.addHierarchy(measureHierarchy);
                }
                mdxSet2.addChild(tNodeBuildTagTuple);
                bUseCrossjoin = false;
            }
            if (group.getNumberChildren() > 1) {
                AbstractMDXSet child = (AbstractMDXSet)group.getChild(1);
                if (child.getType() == 1039) {
                    child = (AbstractMDXSet)child.getChild(0);
                }
                if (child.getType() == 1027) {
                    group = (CogMDXGroup)child;
                    continue;
                }
                group = null;
                continue;
            }
            group = null;
        }
        if (bUseCrossjoin) {
            if (measureExpr != null) {
                MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)nodeFactory.createNode(1030);
                orderExpr.insertParent(mdxCrossjoin);
                mdxCrossjoin.addChild(measureExpr);
            }
            mdxSet.detach();
        } else {
            MDXGenerate mdxGenerate = (MDXGenerate)nodeFactory.createNode(1057);
            orderExpr.insertParent(mdxGenerate);
            mdxGenerate.addChild(mdxSet);
            mdxGenerate.setAll(true);
            MDXSet mdxCurrentMemberSet = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)nodeFactory, MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, lastLevelInfo.getHierarchyInfo().getProjectedHierarchy(0), null));
            if (measureExpr != null) {
                MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)nodeFactory.createNode(1030);
                mdxSet2.addChild(mdxCrossjoin);
                mdxCrossjoin.addChild(mdxCurrentMemberSet);
                mdxCrossjoin.addChild(measureExpr);
            } else {
                mdxSet2.addChild(mdxCurrentMemberSet);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] sortItems = node.getChildrenOfType(1118);
        for (int i = 0; i < sortItems.length; ++i) {
            if (!ConvertValueSortItemInNonDetailGroup.nodeCondition(sortItems[i], null)) continue;
            this.traceNodeCondition(false, "TNodeSortItems are invalid.", trace);
            return false;
        }
        if (node.getParent() != null && node.getParent().getType() == 1042 && node.getParent().getNumberChildren() == 1 && node.getParent().getParent() != null && node.getParent().getParent().getType() == 1087) {
            this.traceNodeCondition(false, "The TNodeSort is under a head suppression count", trace);
            return false;
        }
        this.traceNodeCondition(true, "TNodeSortItems are valid.", trace);
        return true;
    }
}

