/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.sort;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class MoveMeasuresOutOfSortDetails
extends Transformation {
    public MoveMeasuresOutOfSortDetails() {
        this.mName = "Move Measures Out Of Sort Details";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{1117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode subtree = node.getChild(0);
        while (true) {
            MDXHierInfo hierInfo;
            if ((hierInfo = ((AbstractMDXSet)subtree.getChild(0)).getHierarchyInfo()).projectsMeasures()) {
                if (subtree == node.getChild(0)) {
                    IXQEQueryNode[] sortItemNodes = node.getChildrenOfType(1118);
                    for (int i = 0; i < sortItemNodes.length; ++i) {
                        sortItemNodes[i].detach();
                    }
                    CogMDXReportSummary.updateRefSummary(node, node.getChild(0));
                    node.extract();
                    return;
                }
                subtree.getParent().detachSecondChild();
                node.addChild(subtree, 1);
                return;
            }
            subtree = subtree.getChild(1);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode subtree = node.getChild(0);
        while (true) {
            if (subtree.getType() != 1027 && subtree.getType() != 1026) {
                this.traceNodeCondition(false, "First child is not a chain of Group/Nest nodes.", trace);
                return false;
            }
            MDXHierInfo hierInfo = ((AbstractMDXSet)subtree.getChild(0)).getHierarchyInfo();
            if (hierInfo.projectsMeasures()) {
                this.traceNodeCondition(true, "There is a projected measure to move.", trace);
                return true;
            }
            if (subtree.getNumberChildren() < 2) break;
            subtree = subtree.getChild(1);
        }
        this.traceNodeCondition(false, "There is no projected measure to move.", trace);
        return false;
    }
}

