/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXIsEmpty;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.Iterator;
import java.util.List;

public final class ConvertCountAggregateOnSetToMDXSummary
extends Transformation {
    public ConvertCountAggregateOnSetToMDXSummary() {
        this.mName = "Convert summary aggregation counting number of distinct members to final MDX.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{1087};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String countOnProjectedColumn = (String)node.getPropertyValue("CountOnProjectedNonMeasureColumn");
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XQEBaseQueryNode targetGroup = null;
        List<IXQEQueryNode> cogMDXGroupNodes = node.getChild(0).getDescendantsOfTypeOrdered(1027, true);
        for (CogMDXGroup cogMDXGroup : cogMDXGroupNodes) {
            if (((String)cogMDXGroup.getPropertyValue("refDataItem")).equals(countOnProjectedColumn)) {
                cogMDXGroup.setProjectNonDetailsOnly();
                targetGroup = cogMDXGroup;
                continue;
            }
            cogMDXGroup.setProjectDetailsOnly();
        }
        MDXHierInfo mDXHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        if (mDXHierInfo.getNumProjectedHierarchies() > 1) {
            MDXHierInfo targetHierarchyInfo = ((AbstractMDXSet)targetGroup.getChild(0)).getHierarchyInfo();
            IHierarchy hierarchy = targetHierarchyInfo.getProjectedHierarchy(0);
            IXQEQueryNode mdxExtract = nodeFactory.createNode(1106);
            node.getChild(0).insertParent(mdxExtract);
            mdxExtract.addChild(MDXBuilder.buildMDXBaseHierarchyExpr(nodeFactory, hierarchy));
            MDXCount mdxCount = (MDXCount)node;
            if (!mdxCount.includeEmpty()) {
                mdxCount.setIncludeEmpty(true);
                IHierarchy useHierarchy = mDXHierInfo.getProjectedHierarchy(0);
                AbstractMDXNode expr = MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, useHierarchy);
                MDXIsEmpty isEmpty = MDXBuilder.buildMDXIsEmptyExpr(nodeFactory, MDXBuilder.coerceToValueExpression(expr, nodeFactory));
                expr = MDXBuilder.buildMDXNotExpr(nodeFactory, isEmpty);
                IXQEQueryNode mdxFilter = nodeFactory.createNode(1053);
                mdxExtract.getChild(0).insertParent(mdxFilter);
                mdxFilter.addChild(expr);
            }
        } else {
            IXQEQueryNode mdxDistinct = nodeFactory.createNode(1033);
            node.getChild(0).insertParent(mdxDistinct);
        }
        node.removeProperty("CountOnProjectedNonMeasureColumn");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child node of the target MDXCount node are invalid.", trace);
            return false;
        }
        String countOnProjectedColumn = (String)node.getPropertyValue("CountOnProjectedNonMeasureColumn");
        if (countOnProjectedColumn == null) {
            this.traceNodeCondition(false, "The CountOnProjectedNonMeasureColumn property has not been set on the target MDXCount node.", trace);
            return false;
        }
        List<IXQEQueryNode> cogMDXGroupNodes = node.getChild(0).getDescendantsOfTypeOrdered(1027, true);
        Iterator<IXQEQueryNode> it = cogMDXGroupNodes.iterator();
        boolean status = false;
        while (it.hasNext()) {
            CogMDXGroup cogMDXGroup = (CogMDXGroup)it.next();
            if (!((String)cogMDXGroup.getPropertyValue("refDataItem")).equals(countOnProjectedColumn)) continue;
            status = true;
            break;
        }
        if (status) {
            this.traceNodeCondition(status, "The summary is a count on a set that is projected by the first operand of the target MDXCount node.", trace);
        } else {
            this.traceNodeCondition(status, "The summary is a count on a set that is not projected by the first operand of the target MDXCount node.", trace);
        }
        return status;
    }
}

