/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public class ConvertReportSummaryExprToCM
extends Transformation {
    public ConvertReportSummaryExprToCM() {
        this.mName = "Convert the report summary expressions to a calculated member.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{1028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXReportSummaryExpr reportSummaryExpr = (CogMDXReportSummaryExpr)node;
        MDXQuery mdQuerySpec = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy hierarchy = reportSummaryExpr.getHierarchy();
        int solveOrder = reportSummaryExpr.getSolveOrder();
        solveOrder = Math.max(solveOrder, 1);
        AbstractMDXNode summaryExpr = (AbstractMDXNode)reportSummaryExpr.detachChild(0);
        MDXCalculatedMemberReference mdxCalcMemberRef = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdQuerySpec, hierarchy, "_RS", summaryExpr, solveOrder);
        mdxCalcMemberRef.setIsReportSumary();
        reportSummaryExpr.addChild(mdxCalcMemberRef, 0);
        MDXBuilder.coerceToValueExpression(reportSummaryExpr.getChild(0), nodeFactory);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        CogMDXReportSummaryExpr reportSummaryExpr = (CogMDXReportSummaryExpr)node;
        CogMDXReportSummary reportSummary = (CogMDXReportSummary)reportSummaryExpr.getAncestorOfType(1080);
        AbstractMDXSet theNodeTheSummaryIsfor = (AbstractMDXSet)reportSummary.getDetailExpr();
        if (theNodeTheSummaryIsfor == null) {
            status = true;
            this.traceNodeCondition(status, "There is no projected set, the dimension for the CM will be extracted from its expression.", trace);
            return status;
        }
        status = theNodeTheSummaryIsfor.isOfCategory(1021);
        if (!status) {
            StringBuilder reason = new StringBuilder("The projected set has not been converted to MDX yet, ");
            reason.append("this transformation needs to wait so that the dimension for CM becomes available.");
            this.traceNodeCondition(status, reason.toString(), trace);
            return status;
        }
        this.traceNodeCondition(status, "The dimensionality of the set is available.", trace);
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        boolean bl = status = !((CogMDXReportSummaryExpr)node).isACalculatedMemberReference();
        if (!status) {
            this.traceNodeCondition(status, "All report expression are Calculated Members.", trace);
            return status;
        }
        MDXEdge mdxEdge = (MDXEdge)node.getAncestorOfType(1006);
        if (mdxEdge != null) {
            CogMDXReportSummary reportSummary = (CogMDXReportSummary)node.getAncestorOfType(1080);
            List<IXQEQueryNode> summaryExprs = mdxEdge.getDescendantsOfTypeOrdered(1028, false);
            for (IXQEQueryNode summaryExpr : summaryExprs) {
                CogMDXReportSummary currReportSummary = (CogMDXReportSummary)summaryExpr.getAncestorOfType(1080);
                if (currReportSummary.getNumAncestorGroups() <= reportSummary.getNumAncestorGroups()) continue;
                this.traceNodeCondition(false, "Inner summaries must be transformed first.", trace);
                return false;
            }
        }
        this.traceNodeCondition(status, "One report expression is not a Calculated Member yet and the associated set is fully converted.", trace);
        return status;
    }
}

