/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.ast.olap.TNodeHeadCount;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.MiscellaneousUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SuppressNonDetail
extends Transformation {
    private static final String PROP_SUPPRESSED_NON_DETAILS = "prop_suppressed_non_details";

    public SuppressNonDetail() {
        this.mName = "Suppress non details when all details are empty.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{1027};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
    }

    public List<IXQEQueryNode> findDetailSiblingGroups(IXQEQueryNode group) {
        ArrayList<IXQEQueryNode> siblings = new ArrayList();
        IXQEQueryNode parentGroup = group.getAncestorOfCategory(1027);
        MDXSet set = (MDXSet)group.getAncestorOfType(1039);
        if (set != null) {
            siblings = set.getDescendantsOfTypeOrdered(1027, false);
        }
        Iterator siblingsIterator = siblings.iterator();
        while (siblingsIterator.hasNext()) {
            CogMDXGroup sibling = (CogMDXGroup)siblingsIterator.next();
            if (sibling == group) {
                siblingsIterator.remove();
                continue;
            }
            if (sibling.getAncestorOfType(1027) != parentGroup || !set.isProjectedDescendant(sibling)) {
                siblingsIterator.remove();
                continue;
            }
            String detailProperty = sibling.getDetailProperty();
            if (detailProperty != null && detailProperty.equalsIgnoreCase("true")) continue;
            siblingsIterator.remove();
        }
        return siblings;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXGroup group = (CogMDXGroup)node;
        List<IXQEQueryNode> siblings = this.findDetailSiblingGroups(group);
        TNodeApplyHeadSuppression tNodeApplyHeadSuppression = (TNodeApplyHeadSuppression)nodeFactory.createNode(1083);
        TNodeHeadCount tCount = (TNodeHeadCount)nodeFactory.createNode(1182);
        int numberOfProjectedTuples = group.getNumberOfProjectedTuples();
        if (numberOfProjectedTuples > 0) {
            if (group.getTagType() == "eachTuple") {
                numberOfProjectedTuples = numberOfProjectedTuples * 2 - 1;
            } else if (group.getTagType() == "firstTuple") {
                ++numberOfProjectedTuples;
            }
        }
        tCount.setConstantValue(numberOfProjectedTuples);
        tNodeApplyHeadSuppression.setTNodeHeadCount(tCount);
        group.insertParent(tNodeApplyHeadSuppression);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode edge = node.getAncestorOfType(1006);
        for (IXQEQueryNode sibling : siblings) {
            IXQEQueryNode aliasDef;
            int order;
            AbstractMDXSet projectedSet = (AbstractMDXSet)sibling;
            if (projectedSet.getType() == 1027 && projectedSet.getNumberChildren() == 1) {
                projectedSet = (AbstractMDXSet)projectedSet.getChild(0);
            }
            if ((order = MiscellaneousUtilities.getOrderOfNodesInSubtree(edge, node, projectedSet)) == 0) {
                node.throwInternalError("Error finding order of nodes in tree.");
            }
            MDXSetAliasReference aliasRef = null;
            if (projectedSet.getType() == 1004) {
                aliasRef = (MDXSetAliasReference)nodeFactory.createNode(1015);
                aliasRef.setDefinition(projectedSet);
                projectedSet = (AbstractMDXSet)projectedSet.getChild(0);
                order = MiscellaneousUtilities.getOrderOfNodesInSubtree(edge, node, projectedSet);
            } else if (projectedSet.getType() == 1015) {
                aliasDef = ((MDXSetAliasReference)projectedSet).getDefinition();
                aliasRef = (MDXSetAliasReference)nodeFactory.createNode(1015);
                aliasRef.setDefinition(aliasDef);
                projectedSet = (AbstractMDXSet)((XQEBaseQueryNode)aliasDef).getChild(0);
                order = MiscellaneousUtilities.getOrderOfNodesInSubtree(edge, node, projectedSet);
            } else {
                aliasRef = MDXBuilder.buildMDXSetAlias(nodeFactory, mdxQuery, projectedSet);
            }
            if (order > 0) {
                tNodeApplyHeadSuppression.addChild(aliasRef);
                continue;
            }
            aliasDef = projectedSet.getParent();
            aliasDef.getParent().exchangeChildNode(aliasDef, aliasRef);
            tNodeApplyHeadSuppression.addChild(aliasDef);
        }
        group.setPropertyValue(PROP_SUPPRESSED_NON_DETAILS, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] tnodeUnbalancedCompensations;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        for (IXQEQueryNode tnodeUnbalancedCompensation : tnodeUnbalancedCompensations = node.getAncestorsOfType(1113)) {
            IXQEQueryNode secondChildOfUnbalancedCompensation;
            if (tnodeUnbalancedCompensation == null || tnodeUnbalancedCompensation.getNumberChildren() < 2 || !node.isAncestor(secondChildOfUnbalancedCompensation = tnodeUnbalancedCompensation.getChild(1))) continue;
            this.traceQueryCondition(status, "Group the descendant of the second child of an unbalanced compensation set and does not need suppression.", trace);
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        CogMDXGroup group = (CogMDXGroup)node;
        boolean bl = status = group.getPropertyValue(PROP_SUPPRESSED_NON_DETAILS) == null;
        if (!status) {
            this.traceNodeCondition(status, "Non-Detail suppression already applied", trace);
            return status;
        }
        String detailProp = group.getDetailProperty();
        boolean bl2 = status = detailProp != null && detailProp.equalsIgnoreCase("false") && !group.isNonDetailGroupBodyValue();
        if (!status) {
            this.traceNodeCondition(status, "Detail group does not need suppression", trace);
            return status;
        }
        boolean bl3 = status = group.getPropertyValue("treatedAsReportSummary") == null || (Boolean)group.getPropertyValue("treatedAsReportSummary") == false;
        if (!status) {
            this.traceNodeCondition(status, "Suppression on ReporterMode summaries not supported yet.", trace);
            return status;
        }
        List<IXQEQueryNode> siblings = this.findDetailSiblingGroups(group);
        boolean bl4 = status = siblings.size() >= 1;
        if (!status) {
            this.traceNodeCondition(status, "Detail group has no associated detail", trace);
            return status;
        }
        for (IXQEQueryNode sibling : siblings) {
            AbstractMDXSet siblingGroup = (AbstractMDXSet)sibling;
            status = siblingGroup.couldResolveToEmptySet(true, false, false);
            if (status) continue;
            this.traceNodeCondition(status, "Suppression not required: detail set cannot be empty", trace);
            return status;
        }
        this.traceNodeCondition(status, "Non detail group sibling of some details, suppression will be applied", trace);
        return status;
    }
}

