/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;

public final class ApplySummaryFilterMultipleScopesToSet
extends Transformation {
    public ApplySummaryFilterMultipleScopesToSet() {
        this.mName = "Apply Summary Filter With Multiple Scopes To Detail Set.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1141};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)node;
        MDXLevelInfo level = ((AbstractMDXSet)tNode.getChild(0)).getLevelInfo();
        IHierarchy hier = level.getHierarchyInfo().getProjectedHierarchy(0);
        Integer summaryFilterId = tNode.getSummaryFilterId();
        CogMDXSummaryFilter cogMDXSummaryFilter = (CogMDXSummaryFilter)factory.getNodeIndex().getNodeByID(summaryFilterId);
        List<String> scopedDataItemNames = cogMDXSummaryFilter.getScopedDataItemNames();
        AbstractMDXBooleanExpression condition = (AbstractMDXBooleanExpression)factory.deepCopyNode(cogMDXSummaryFilter.getChild(0));
        boolean detailScope = cogMDXSummaryFilter.getBooleanPropertyValue("fromUpgradedVDF") == Boolean.TRUE;
        AbstractMDXSet aggrSet = this.applyCase1Transformation(environment, tNode, scopedDataItemNames, condition, detailScope);
        if (tNode.hasNestedSet()) {
            aggrSet = this.applyCase2Transformation(environment, tNode, aggrSet);
        }
        if (aggrSet != null) {
            SFUtil.aggrCtxtDepValExprCondOperands(environment, aggrSet, condition, false, null, tNode);
        }
        MDXLevelInfo scopedLevel = null;
        if (tNode.hasNestedSet() && tNode.getNestedSet().getHierarchyInfo().projectsHierarchy(hier)) {
            scopedLevel = new MDXLevelInfo();
            scopedLevel.addProjectedLevels(level.getProjectedLevels(hier));
        }
        SFUtil.flagApplySummaryFilterToProjectedMeasures(factory, mdxQuery, summaryFilterId, scopedLevel, condition);
        node.detachChildrenExceptFirst();
        node.extract();
    }

    private AbstractMDXSet applyCase1Transformation(PlanningEnvironment environment, TNodeApplySummaryFilterToSet tNode, List<String> scopedDataItemNames, AbstractMDXBooleanExpression condition, boolean detailScope) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXFilter mdxFilter = (MDXFilter)factory.createNode(1053);
        mdxFilter.setIsMeasureSummaryFilter(Boolean.TRUE);
        tNode.getChild(0).insertParent(mdxFilter);
        MDXCount mdxCount = (MDXCount)factory.createNode(1087);
        MDXComparisonOperator gtExpr = MDXBuilder.buildMDXComparisonExpr(factory, 3, mdxCount, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0));
        mdxFilter.addChild(gtExpr);
        mdxFilter = (MDXFilter)factory.createNode(1053);
        mdxCount.addChild(mdxFilter);
        mdxFilter.setIsMeasureSummaryFilter(Boolean.TRUE);
        XQEBaseQueryNode aggrSet = null;
        AbstractMDXSet[] oppositeEdgeSets = tNode.getOppositeEdgeSets();
        for (int i = 0; i < oppositeEdgeSets.length; ++i) {
            AbstractMDXSet oppositeEdgeSet = (AbstractMDXSet)factory.deepCopyNode(oppositeEdgeSets[i]);
            IXQEQueryNode[] cogMDXGroupNodes = oppositeEdgeSet.getDescendantsOfType(1027, true);
            for (int j = 0; j < cogMDXGroupNodes.length; ++j) {
                CogMDXGroup cogMDXGroup = (CogMDXGroup)cogMDXGroupNodes[j];
                if (!oppositeEdgeSet.isProjectedDescendant(cogMDXGroup) || !scopedDataItemNames.contains(cogMDXGroup.getPropertyValue("refDataItem"))) continue;
                cogMDXGroup.detachChildrenExceptFirst();
                if (detailScope) continue;
                this.detachSiblingsAbove(cogMDXGroup);
                break;
            }
            if (aggrSet == null) {
                aggrSet = oppositeEdgeSet;
                continue;
            }
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxCrossjoin.addChild(aggrSet);
            aggrSet = mdxCrossjoin;
            mdxCrossjoin.addChild(oppositeEdgeSet);
        }
        SFUtil.setProjectDetailsOnlyOnCogMDXGroups(aggrSet);
        this.setProjectNonDetailsOnlyOnScopedCogMDXGroups((AbstractMDXSet)aggrSet, scopedDataItemNames);
        mdxFilter.addChild(aggrSet);
        aggrSet.insertParent(factory.createNode(1139, tNode));
        environment.enableLockNodeQueryPlanning(1139);
        mdxFilter.addChild(condition);
        aggrSet = this.buildOppEdgesAggrSet(environment, tNode, scopedDataItemNames);
        return aggrSet;
    }

    void detachSiblingsAbove(CogMDXGroup cogMDXGroup) {
        for (CogMDXGroup currentGroup = cogMDXGroup; currentGroup != null; currentGroup = (CogMDXGroup)currentGroup.getAncestorOfType(1027)) {
            this.detachSiblings(currentGroup);
        }
    }

    void detachSiblings(AbstractMDXSet set) {
        IXQEQueryNode parent = set.getParent();
        if (parent == null || parent.getType() != 1039) {
            return;
        }
        for (IXQEQueryNode child : parent.getChildren()) {
            CogMDXGroup mdxGroup;
            if (child == set || child.getType() != 1027 || (mdxGroup = (CogMDXGroup)child).isRaggedCompensation() || mdxGroup.isUnbalancedCompensation()) continue;
            mdxGroup.detach();
        }
    }

    private AbstractMDXSet applyCase2Transformation(PlanningEnvironment environment, TNodeApplySummaryFilterToSet tNode, AbstractMDXSet aggrSet) {
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXSet nestedSet = (AbstractMDXSet)factory.deepCopyNode(tNode.getNestedSet());
        nestedSet = SFUtil.removeSetFromAncestorLevels(nestedSet, tNode);
        if (aggrSet == null) {
            aggrSet = nestedSet;
        } else if (nestedSet != null) {
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            mdxCrossjoin.addChild(nestedSet);
            mdxCrossjoin.addChild(aggrSet);
            aggrSet = mdxCrossjoin;
        }
        return aggrSet;
    }

    public void setProjectNonDetailsOnlyOnScopedCogMDXGroups(AbstractMDXSet set, List<String> scopedDataItemNames) {
        IXQEQueryNode[] cogMDXGroupNodes = set.getDescendantsOfType(1027, true);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            CogMDXGroup cogMDXGroup = (CogMDXGroup)cogMDXGroupNodes[i];
            if (!set.isProjectedDescendant(cogMDXGroup) || !scopedDataItemNames.contains(cogMDXGroup.getPropertyValue("refDataItem"))) continue;
            cogMDXGroup.setProjectNonDetailsOnly();
        }
    }

    public AbstractMDXSet buildOppEdgesAggrSet(PlanningEnvironment environment, TNodeApplySummaryFilterToSet tNode, List<String> scopedDataItemNames) {
        XQENodeFactory factory = environment.getNodeFactory();
        ArrayList<AbstractMDXSet> nestedSets = new ArrayList<AbstractMDXSet>();
        AbstractMDXSet[] oppositeEdgeSets = tNode.getOppositeEdgeSets();
        block0: for (int i = 0; i < oppositeEdgeSets.length; ++i) {
            AbstractMDXSet oppositeEdgeSet = oppositeEdgeSets[i];
            IXQEQueryNode[] cogMDXGroupNodes = oppositeEdgeSet.getDescendantsOfType(1027, true);
            for (int j = 0; j < cogMDXGroupNodes.length; ++j) {
                MDXHierInfo hierInfo;
                CogMDXGroup cogMDXGroup = (CogMDXGroup)cogMDXGroupNodes[j];
                if (!oppositeEdgeSet.isProjectedDescendant(cogMDXGroup) || !scopedDataItemNames.contains(cogMDXGroup.getPropertyValue("refDataItem"))) continue;
                if (cogMDXGroup.getNumberChildren() != 2 || (hierInfo = ((AbstractMDXSet)cogMDXGroup.getChild(1)).getHierarchyInfo()).getNumberOfNonMeasureHierarchiesProjected() <= 0) continue block0;
                nestedSets.add((AbstractMDXSet)factory.deepCopyNode(cogMDXGroup.getChild(1)));
                continue block0;
            }
        }
        AbstractMDXSet result = null;
        if (nestedSets.size() > 0) {
            for (AbstractMDXSet set : nestedSets) {
                if (result == null) {
                    result = set;
                    continue;
                }
                MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
                mdxCrossjoin.addChild(result);
                mdxCrossjoin.addChild(set);
            }
        }
        return result;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> tNodes;
        MDXEdge mdxEdge;
        CogMDXGroup parentCogMDXGroup;
        XQENodeFactory factory = environment.getNodeFactory();
        XQETrace trace = environment.getTrace();
        TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)node;
        Integer summaryFilterId = tNode.getSummaryFilterId();
        CogMDXSummaryFilter cogMDXSummaryFilter = (CogMDXSummaryFilter)factory.getNodeIndex().getNodeByID(summaryFilterId);
        if (cogMDXSummaryFilter.getScopedDataItemNames().size() < 2) {
            this.traceNodeCondition(false, "The CogMDXSummaryFilter for the target TNodeApplySummaryFilterToSet does not have multiple scopes.", trace);
            return false;
        }
        if (cogMDXSummaryFilter.getNumberOfScopedEdges() < 2) {
            this.traceNodeCondition(false, "The CogMDXSummaryFilter for the target TNodeApplySummaryFilterToSet is not scoped to multiple edges.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target TNodeApplySummaryFilterToSet node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!cogMDXSummaryFilter.isAncestor(mdxQuery)) {
            node.throwInternalError("Internal Error.");
        }
        if ((parentCogMDXGroup = (CogMDXGroup)node.getAncestorOfType(1027)) == null || parentCogMDXGroup.isDescendantOfNodeInSubtree(parentCogMDXGroup, 0) || !parentCogMDXGroup.isProjectedDescendant((AbstractMDXNode)node)) {
            node.throwInternalError("");
        }
        IXQEQueryNode[] cogMDXSummaryFilterNodes = mdxQuery.getDescendantsOfType(1011, false);
        for (int i = 0; i < cogMDXSummaryFilterNodes.length; ++i) {
            if (cogMDXSummaryFilterNodes[i].getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The MDXQuery still contains CogMDXSummaryFilter nodes that have not yet been distributed to the MDXQuery.", trace);
            return false;
        }
        if (mdxQuery.getNumberOfEdges() > 1 && SFUtil.getNumEdgesThatProjectDetails(mdxQuery) > 1) {
            if (!tNode.hasOppositeEdgeSets()) {
                this.traceNodeCondition(false, "The query contains multiple edges that project details and these opposite edge detail expressions have not get been copied to the target TNodeApplySummaryFilterToSet node.", trace);
                return false;
            }
            IXQEQueryNode[] tNodes2 = mdxQuery.getDescendantsOfType(1141, false);
            for (int i = 0; i < tNodes2.length; ++i) {
                if (tNodes2[i] == node || ((TNodeApplySummaryFilterToSet)tNodes2[i]).hasOppositeEdgeSets()) continue;
                this.traceNodeCondition(false, "The query contains multiple edges that project details and there are TNodeApplySummaryFilterToSet nodes in the query that do not yet have copies of these opposite edge detail expressions.", trace);
                return false;
            }
        }
        if ((mdxEdge = (MDXEdge)node.getAncestorOfType(1006)) != null && (tNodes = mdxEdge.getDescendantsOfTypeOrdered(1141, false)).get(tNodes.size() - 1) != tNode) {
            this.traceNodeCondition(true, "This is not the last TNode of this type.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

