/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.AbstractOLAPDecoration;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToProjectedMeasure;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.List;

public class ApplySummaryFilterToProjectedMeasures
extends Transformation {
    public ApplySummaryFilterToProjectedMeasures() {
        this.mName = "Apply Summary Filter To Projected Measures In Query.";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{1173};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] applyingSFtoMeasureTnodes = mdxQuery.getDescendantsOfType(1173, false);
        for (int i = 0; i < applyingSFtoMeasureTnodes.length; ++i) {
            TNodeApplySummaryFilterToProjectedMeasure tnode = (TNodeApplySummaryFilterToProjectedMeasure)applyingSFtoMeasureTnodes[i];
            AbstractMDXBooleanExpression condition = SFUtil.buildSingleSummaryFilterConditionExpression(factory, mdxQuery, tnode);
            IXQEQueryNode preSFMember = null;
            preSFMember = tnode.getChild(0).getType() == 1067 ? factory.deepCopyNode(tnode.getChild(0)) : tnode.getChild(0).detach();
            SFUtil.setPreSummaryFilterMeasureFlag(preSFMember);
            MDXNumericIIF iifExpr = MDXBuilder.buildMDXNumericIIFExprWithNull(factory, condition, (AbstractMDXNumericValueExpression)MDXBuilder.coerceToValueExpression(preSFMember, factory));
            MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, mdxQuery.getMeasuresHierarchy(), "_SF", iifExpr, SolveOrderUtil.getCubeCalcSolveOrder());
            cm.setIsV5CalculatedMember();
            if (preSFMember.getType() == 1013) {
                cm.setIsQueryCalculation(((MDXCalculatedMemberReference)preSFMember).isQueryCalculation());
            }
            SFUtil.setPostSummaryFilterMeasureFlag(cm);
            if (tnode.getNumberChildren() > 0 && tnode.getChild(0).getType() == 1067) {
                SFUtil.replaceProjectedBaseMeasureWithPostSummaryFilterCalculatedMeasure((BaseMember)tnode.getChild(0), cm, factory);
            } else {
                tnode.addChild(cm);
                if (preSFMember.getType() == 1013) {
                    List<AbstractOLAPDecoration> decoRefs = ((MDXCalculatedMemberReference)preSFMember).getOlapDecorationRefsProperty();
                    if (decoRefs != null) {
                        for (AbstractOLAPDecoration deco : decoRefs) {
                            cm.addOlapDecorationRef(deco);
                        }
                    }
                    cm.getDefinition().setPropertyValue("v5Caption", ((MDXCalculatedMemberReference)preSFMember).getDefinition().getPropertyValue("v5Caption"));
                    cm.getDefinition().setPropertyValue("v5Name", ((MDXCalculatedMemberReference)preSFMember).getDefinition().getPropertyValue("v5Name"));
                    cm.setRollupAggregate(((MDXCalculatedMemberReference)preSFMember).getRollupAggregate());
                }
            }
            tnode.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        IXQEQueryNode[] tnodes = mdxQuery.getDescendantsOfType(1173, false);
        for (int i = 0; i < tnodes.length; ++i) {
            tnodes[i].throwOnInvalidChildCategories();
        }
        this.traceNodeCondition(true, "Summary filter can be applied to projected measures in query.", trace);
        return true;
    }
}

