/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXMemberSummaryFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.DistributeMemberSummaryFilter;
import java.util.List;

public final class CastPostAADetailFilterToSummaryFilter
extends Transformation {
    public static final String PROP_BOOLEAN_FROM_UPGRADED_VALUE_DETAIL_FILTER = "fromUpgradedVDF";

    public CastPostAADetailFilterToSummaryFilter() {
        this.mName = "Cast Post Auto Aggregate Detail Filter to Summary Filter.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1095, 1093};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode summaryFilter = null;
        if (node.getType() == 1093) {
            summaryFilter = factory.createNode(1174);
            TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
            ((CogMDXMemberSummaryFilter)summaryFilter).addCorrelatedHierarchies(tNode.getCorrelatedHierarchies());
        } else {
            summaryFilter = factory.createNode(1011);
        }
        summaryFilter.setPropertyValue("defaultScope", "detail");
        summaryFilter.setPropertyValue(PROP_BOOLEAN_FROM_UPGRADED_VALUE_DETAIL_FILTER, Boolean.TRUE);
        node.exchange(summaryFilter, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object applyBWDBOnly;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
        if (!tNode.getPostAutoAggregation()) {
            this.traceNodeCondition(false, "The Detail Filter timing is before auto aggregation.", trace);
            return false;
        }
        String timing = tNode.getPostAutoAggregationTiming(mdxQuery);
        if (!timing.equals("reportDetails")) {
            this.traceNodeCondition(false, "The Detail Filter post auto aggregation timing is not set to 'reportDetails'", trace);
            return false;
        }
        MDXEdge[] edges = mdxQuery.getEdges();
        boolean queryProjectsNonMeasureHierarchy = false;
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            if (edgeHierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0) continue;
            queryProjectsNonMeasureHierarchy = true;
        }
        if (!queryProjectsNonMeasureHierarchy) {
            this.traceNodeCondition(false, "The edges of the MDXQuery do not project any non-Measure hierarchies.", trace);
            return false;
        }
        if (node.getType() == 1093) {
            TNodeMDFOnSingleHierarchy tNodeMDF = (TNodeMDFOnSingleHierarchy)node;
            if (!mdxQuery.getHierarchyInfo().projectsHierarchy(tNodeMDF.getMDFHierarchy())) {
                this.traceNodeCondition(false, "The MDXQuery does not project the hierarchy " + tNodeMDF.getMDFHierarchy(), trace);
                return false;
            }
            IHierarchy filterHierarchy = tNodeMDF.getMDFHierarchy();
            List<AbstractMDXSet> detailSets = DistributeMemberSummaryFilter.getGroupNestTopMostSets(mdxQuery, filterHierarchy, null);
            if (detailSets.isEmpty()) {
                this.traceNodeCondition(false, "The MDXQuery does not project any sets in hierarchy " + filterHierarchy.getUniqueName(), trace);
                return false;
            }
        }
        if (node.getType() == 1095 && (applyBWDBOnly = mdxQuery.getPropertyValue("applyBWDBOnlyTransformation")) != null && applyBWDBOnly == Boolean.TRUE) {
            this.traceNodeCondition(false, "The MDXQuery is directly against BW database. ", trace);
            return false;
        }
        this.traceNodeCondition(true, "The detail filter can be replace with a summary filter.", trace);
        return true;
    }
}

