/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;

public final class CopyOppositeEdgeExprsToTNodes
extends Transformation {
    public CopyOppositeEdgeExprsToTNodes() {
        this.mName = "Add Opposite Edge Expressions To TNodeApplySummaryFilterToSet.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1141};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            if (node.isAncestor(edges[i]) || SFUtil.getProjectedDetails(edges[i]).length == 0) continue;
            IXQEQueryNode edgeSet = factory.deepCopyNode(edges[i].getChild(0));
            IXQEQueryNode[] tNodes = edgeSet.getDescendantsOfType(1141, false);
            for (int j = 0; j < tNodes.length; ++j) {
                IXQEQueryNode tNode = tNodes[j];
                tNode.detachChildrenExceptFirst();
                tNode.extract();
            }
            node.addChild(edgeSet);
            edgeSet.insertParent(factory.createNode(1139));
        }
        environment.enableLockNodeQueryPlanning(1139);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] nestedSets;
        XQETrace trace = environment.getTrace();
        for (IXQEQueryNode nestedSet : nestedSets = node.getDescendantsOfType(1139, false)) {
            if (nestedSet.getPropertyValue("nestedSet") == null) continue;
            this.traceNodeCondition(false, "The transformation has to wait until all non detail nested set to be removed.", trace);
            return false;
        }
        if (((TNodeApplySummaryFilterToSet)node).hasOppositeEdgeSets()) {
            this.traceNodeCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int numEdges = mdxQuery.getNumberOfEdges();
        if (numEdges == 1) {
            this.traceNodeCondition(false, "The MDXQuery only contains a single edge.", trace);
            return false;
        }
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i].validateChildCategories()) continue;
            this.traceNodeCondition(false, "The MDXQuery has an MDXEdge with invalid child nodes.", trace);
            return false;
        }
        if (SFUtil.getNumEdgesThatProjectDetails(mdxQuery) < 2) {
            this.traceNodeCondition(false, "None of the opposite edges project details.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.  At least one of the opposite edges projects a non-Measure hierarchy.", trace);
        return true;
    }
}

